/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.discovery.ServerVersionAndEdition;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.server.rest.repr.Serializer;

class DiscoveryRepresentationTest {
    DiscoveryRepresentationTest() {
    }

    @Test
    void shouldCreateAMapContainingDataAndManagementURIs() {
        URI baseUri = RepresentationTestBase.BASE_URI;
        String managementUri = "/management";
        String dataUri = "/data";
        Config config = Config.defaults((Setting)BoltConnector.enabled, (Object)true);
        DiscoveryRepresentation dr = new DiscoveryRepresentation(new DiscoverableURIs.Builder().addEndpoint("management", managementUri).addEndpoint("data", dataUri).addBoltEndpoint(config, (ConnectorPortRegister)Mockito.mock(ConnectorPortRegister.class)).build().update(baseUri), (ServerVersionAndEdition)Mockito.mock(ServerVersionAndEdition.class));
        Map<String, Object> mapOfUris = RepresentationTestAccess.serialize((MappingRepresentation)dr);
        Object mappedManagementUri = mapOfUris.get("management");
        Object mappedDataUri = mapOfUris.get("data");
        Object mappedBoltUri = mapOfUris.get("bolt_direct");
        Assertions.assertNotNull((Object)mappedManagementUri);
        Assertions.assertNotNull((Object)mappedDataUri);
        Assertions.assertNotNull((Object)mappedBoltUri);
        Assertions.assertEquals((Object)Serializer.joinBaseWithRelativePath((URI)baseUri, (String)managementUri), (Object)mappedManagementUri.toString());
        Assertions.assertEquals((Object)Serializer.joinBaseWithRelativePath((URI)baseUri, (String)dataUri), (Object)mappedDataUri.toString());
        Assertions.assertEquals((Object)"bolt://neo4j.org:7687", (Object)mappedBoltUri.toString());
    }

    @Test
    void shouldCreateAMapContainingServerVersionAndEditionInfo() {
        ServerVersionAndEdition serverInfo = new ServerVersionAndEdition("myVersion", "myEdition");
        DiscoveryRepresentation dr = new DiscoveryRepresentation((DiscoverableURIs)Mockito.mock(DiscoverableURIs.class), serverInfo);
        Map<String, Object> mapOfUris = RepresentationTestAccess.serialize((MappingRepresentation)dr);
        Object version = mapOfUris.get("neo4j_version");
        Object edition = mapOfUris.get("neo4j_edition");
        Assertions.assertNotNull((Object)version);
        Assertions.assertNotNull((Object)edition);
        Assertions.assertEquals((Object)"myVersion", (Object)version.toString());
        Assertions.assertEquals((Object)"myEdition", (Object)edition.toString());
    }
}

