/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.server.http.cypher.format.output.json.GraphExtractionWriter;
import org.neo4j.server.http.cypher.format.output.json.RestRepresentationWriter;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;
import org.neo4j.server.http.cypher.format.output.json.RowWriter;

public enum ResultDataContent {
    row{

        @Override
        public ResultDataContentWriter writer(URI baseUri) {
            return new RowWriter();
        }
    }
    ,
    graph{

        @Override
        public ResultDataContentWriter writer(URI baseUri) {
            return new GraphExtractionWriter();
        }
    }
    ,
    rest{

        @Override
        public ResultDataContentWriter writer(URI baseUri) {
            return new RestRepresentationWriter(baseUri);
        }
    };


    public abstract ResultDataContentWriter writer(URI var1);

    public static List<ResultDataContent> fromNames(List<?> names) {
        if (names == null) {
            return Collections.emptyList();
        }
        return names.stream().map(name -> {
            if (name instanceof String) {
                try {
                    return ResultDataContent.valueOf(((String)name).toLowerCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid result data content specifier: " + name);
                }
            }
            throw new IllegalArgumentException("Invalid result data content specifier: " + name);
        }).collect(Collectors.toList());
    }
}

