/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.database.DatabaseService;
import org.neo4j.server.http.cypher.TransactionFacade;
import org.neo4j.server.http.cypher.TransactionHandleRegistry;
import org.neo4j.server.http.cypher.TransitionalPeriodTransactionMessContainer;
import org.neo4j.time.Clocks;

public class HttpTransactionManager {
    private final TransactionHandleRegistry transactionRegistry;
    private final DatabaseService database;
    private final JobScheduler jobScheduler;

    public HttpTransactionManager(DatabaseService database, JobScheduler jobScheduler, Clock clock, Duration transactionTimeout, LogProvider userLogProvider) {
        this.database = database;
        this.jobScheduler = jobScheduler;
        this.transactionRegistry = new TransactionHandleRegistry(clock, transactionTimeout, userLogProvider);
        this.scheduleTransactionTimeout(transactionTimeout);
    }

    public Optional<GraphDatabaseFacade> getGraphDatabaseFacade(String databaseName) {
        Optional<GraphDatabaseFacade> graph;
        try {
            graph = Optional.of(this.database.getDatabase(databaseName));
        }
        catch (DatabaseNotFoundException e) {
            graph = Optional.empty();
        }
        return graph;
    }

    public TransactionHandleRegistry getTransactionHandleRegistry() {
        return this.transactionRegistry;
    }

    public TransactionFacade createTransactionFacade(GraphDatabaseFacade graph) {
        DependencyResolver dependencyResolver = graph.getDependencyResolver();
        return new TransactionFacade(new TransitionalPeriodTransactionMessContainer(graph), (QueryExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class), (GraphDatabaseQueryService)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class), this.transactionRegistry);
    }

    private void scheduleTransactionTimeout(Duration timeout) {
        Clock clock = Clocks.systemClock();
        long timeoutMillis = timeout.toMillis();
        long runEvery = Math.round((double)timeoutMillis / 2.0);
        this.jobScheduler.scheduleRecurring(Group.SERVER_TRANSACTION_TIMEOUT, () -> {
            long maxAge = clock.millis() - timeoutMillis;
            this.transactionRegistry.rollbackSuspendedTransactionsIdleSince(maxAge);
        }, runEvery, TimeUnit.MILLISECONDS);
    }
}

