/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.logging.Log;
import org.neo4j.server.database.DatabaseService;
import org.neo4j.server.database.GraphFactory;

public class LifecycleManagingDatabaseService
implements DatabaseService {
    private final Config config;
    private final GraphFactory dbFactory;
    private final ExternalDependencies dependencies;
    private final Log log;
    private boolean isRunning;
    private DatabaseManagementService managementService;

    public LifecycleManagingDatabaseService(Config config, GraphFactory dbFactory, ExternalDependencies dependencies) {
        this.config = config;
        this.dbFactory = dbFactory;
        this.dependencies = dependencies;
        this.log = dependencies.userLogProvider().getLog(this.getClass());
    }

    @Override
    public DatabaseManagementService getDatabaseManagementService() {
        return this.managementService;
    }

    @Override
    public GraphDatabaseFacade getDatabase() {
        return this.getDatabase((String)this.config.get(GraphDatabaseSettings.default_database));
    }

    @Override
    public GraphDatabaseFacade getSystemDatabase() {
        return this.getDatabase("system");
    }

    @Override
    public GraphDatabaseFacade getDatabase(String databaseName) throws DatabaseNotFoundException {
        return (GraphDatabaseFacade)this.managementService.database(databaseName);
    }

    public void init() {
    }

    public void start() {
        this.log.info("Starting...");
        this.managementService = this.dbFactory.newDatabaseManagementService(this.config, this.dependencies);
        this.isRunning = true;
        this.log.info("Started.");
    }

    public void stop() {
        if (this.managementService != null) {
            this.log.info("Stopping...");
            this.managementService.shutdown();
            this.isRunning = false;
            this.managementService = null;
            this.log.info("Stopped.");
        }
    }

    public void shutdown() {
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }
}

