/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.GroupSettingValidator;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.kernel.impl.scheduler.BufferingExecutor;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.scheduler.DeferredExecutor;
import org.neo4j.scheduler.Group;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.DisabledNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerCommandLineArgs;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.logging.JULBridge;
import org.neo4j.server.logging.JettyLogBridge;
import sun.misc.Signal;

public abstract class ServerBootstrapper
implements Bootstrapper {
    public static final int OK = 0;
    private static final int WEB_SERVER_STARTUP_ERROR_CODE = 1;
    private static final int GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    private static final String SIGTERM = "TERM";
    private static final String SIGINT = "INT";
    private volatile NeoServer server;
    private volatile Closeable userLogFileStream;
    private Thread shutdownHook;
    private GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies();
    private Log log = FormattedLogProvider.toOutputStream((OutputStream)System.out).getLog(this.getClass());
    private String serverAddress = "unknown address";

    public static int start(Bootstrapper boot, String ... argv) {
        ServerCommandLineArgs args = ServerCommandLineArgs.parse(argv);
        if (args.version()) {
            System.out.println("neo4j " + Version.getNeo4jVersion());
            return 0;
        }
        if (args.homeDir() == null) {
            throw new ServerStartupException("Argument --home-dir is required and was not provided.");
        }
        return boot.start(args.homeDir(), args.configFile(), args.configOverrides());
    }

    @Override
    public final int start(File homeDir, Optional<File> configFile, Map<String, String> configOverrides) {
        this.addShutdownHook();
        this.installSignalHandlers();
        Config config = Config.newBuilder().setDefaults(GraphDatabaseSettings.SERVER_DEFAULTS).fromFileNoThrow((File)configFile.orElse(null)).setRaw(configOverrides).set(GraphDatabaseSettings.neo4j_home, (Object)homeDir.toPath().toAbsolutePath()).addValidators(this.configurationValidators()).build();
        try {
            LogProvider userLogProvider = this.setupLogging(config);
            this.dependencies = this.dependencies.userLogProvider(userLogProvider);
            this.log = userLogProvider.getLog(this.getClass());
            config.setLogger(this.log);
            this.serverAddress = HttpConnector.listen_address.toString();
            this.server = this.createNeoServer(config, this.dependencies);
            this.server.start();
            return 0;
        }
        catch (ServerStartupException e) {
            e.describeTo(this.log);
            return 1;
        }
        catch (TransactionFailureException tfe) {
            String locationMsg = this.server == null ? "" : " Another process may be using databases at location: " + config.get(GraphDatabaseSettings.databases_root_path);
            this.log.error(String.format("Failed to start Neo4j on %s.", this.serverAddress) + locationMsg, (Throwable)tfe);
            return 2;
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to start Neo4j on %s.", this.serverAddress), (Throwable)e);
            return 1;
        }
    }

    protected List<Class<? extends GroupSettingValidator>> configurationValidators() {
        return List.of();
    }

    @Override
    public int stop() {
        String location = "unknown location";
        try {
            this.doShutdown();
            this.removeShutdownHook();
            return 0;
        }
        catch (Exception e) {
            this.log.error("Failed to cleanly shutdown Neo Server on port [%s], database [%s]. Reason [%s] ", new Object[]{this.serverAddress, location, e.getMessage(), e});
            return 1;
        }
    }

    public boolean isRunning() {
        return this.server != null && this.server.getDatabaseService() != null && this.server.getDatabaseService().isRunning();
    }

    public NeoServer getServer() {
        return this.server;
    }

    public Log getLog() {
        return this.log;
    }

    private NeoServer createNeoServer(Config config, GraphDatabaseDependencies dependencies) {
        boolean httpAndHttpsDisabled;
        GraphFactory graphFactory = this.createGraphFactory(config);
        boolean bl = httpAndHttpsDisabled = (Boolean)config.get(HttpConnector.enabled) == false && (Boolean)config.get(HttpsConnector.enabled) == false;
        if (httpAndHttpsDisabled) {
            return new DisabledNeoServer(graphFactory, (ExternalDependencies)dependencies, config);
        }
        return this.createNeoServer(graphFactory, config, dependencies);
    }

    protected abstract GraphFactory createGraphFactory(Config var1);

    protected abstract NeoServer createNeoServer(GraphFactory var1, Config var2, GraphDatabaseDependencies var3);

    private LogProvider setupLogging(Config config) {
        FormattedLogProvider.Builder builder = FormattedLogProvider.withoutRenderingContext().withZoneId(((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId()).withDefaultLogLevel((Level)config.get(GraphDatabaseSettings.store_internal_log_level));
        FormattedLogProvider userLogProvider = (Boolean)config.get(GraphDatabaseSettings.store_user_log_to_stdout) != false ? builder.toOutputStream((OutputStream)System.out) : this.createFileSystemUserLogProvider(config, builder);
        JULBridge.resetJUL();
        Logger.getLogger("").setLevel(java.util.logging.Level.WARNING);
        JULBridge.forwardTo((LogProvider)userLogProvider);
        JettyLogBridge.setLogProvider((LogProvider)userLogProvider);
        return userLogProvider;
    }

    private void installSignalHandlers() {
        this.installSignalHandler(SIGTERM, false);
        this.installSignalHandler(SIGINT, true);
    }

    private void installSignalHandler(String sig, boolean tolerateErrors) {
        block2: {
            try {
                Signal.handle(new Signal(sig), signal -> System.exit(0));
            }
            catch (Throwable e) {
                if (tolerateErrors) break block2;
                throw e;
            }
        }
    }

    private void doShutdown() {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.userLogFileStream != null) {
            this.closeUserLogFileStream();
        }
    }

    private void closeUserLogFileStream() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new Closeable[]{this.userLogFileStream});
    }

    private void addShutdownHook() {
        this.shutdownHook = new Thread(() -> {
            this.log.info("Neo4j Server shutdown initiated by request");
            this.doShutdown();
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null && !Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
            this.log.warn("Unable to remove shutdown hook");
        }
    }

    private LogProvider createFileSystemUserLogProvider(Config config, FormattedLogProvider.Builder builder) {
        BufferingExecutor deferredExecutor = new BufferingExecutor();
        this.dependencies = this.dependencies.withDeferredExecutor((DeferredExecutor)deferredExecutor, Group.LOG_ROTATION);
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        File destination = ((Path)config.get(GraphDatabaseSettings.store_user_log_path)).toFile();
        Long rotationThreshold = (Long)config.get(GraphDatabaseSettings.store_user_log_rotation_threshold);
        try {
            if (rotationThreshold == 0L) {
                OutputStream userLog = FileSystemUtils.createOrOpenAsOutputStream((FileSystemAbstraction)fs, (File)destination, (boolean)true);
                this.userLogFileStream = userLog;
                return builder.toOutputStream(userLog);
            }
            RotatingFileOutputStreamSupplier rotatingUserLogSupplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)fs, destination, rotationThreshold.longValue(), ((Duration)config.get(GraphDatabaseSettings.store_user_log_rotation_delay)).toMillis(), ((Integer)config.get(GraphDatabaseSettings.store_user_log_max_archives)).intValue(), (Executor)deferredExecutor);
            this.userLogFileStream = rotatingUserLogSupplier;
            return builder.toOutputStream((Supplier)rotatingUserLogSupplier);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

