/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.neo4j.kernel.api.exceptions.Status;

public class Neo4jError {
    private final Status status;
    private final Throwable cause;

    public Neo4jError(Status status, String message) {
        this(status, new RuntimeException(message));
    }

    public Neo4jError(Status status, Throwable cause) {
        if (status == null) {
            throw new IllegalArgumentException("statusCode must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("cause must not be null");
        }
        this.status = status;
        this.cause = cause;
    }

    public String toString() {
        this.cause.printStackTrace();
        return String.format("%s[%s, cause=\"%s\"]", this.getClass().getSimpleName(), this.status.code(), this.cause);
    }

    public Throwable cause() {
        return this.cause;
    }

    public Status status() {
        return this.status;
    }

    public String getMessage() {
        return this.cause.getMessage();
    }

    public boolean shouldSerializeStackTrace() {
        switch (this.status.code().classification()) {
            case ClientError: {
                return false;
            }
        }
        return true;
    }

    public String getStackTraceAsString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.cause.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

