/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.neo4j.configuration.Config;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.discovery.ServerVersionAndEdition;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/")
public class DiscoveryService {
    private final Config config;
    private final OutputFormat outputFormat;
    private final DiscoverableURIs uris;
    private final ServerVersionAndEdition serverInfo;

    public DiscoveryService(@Context Config config, @Context OutputFormat outputFormat, @Context DiscoverableURIs uris, @Context NeoServer neoServer) {
        this(config, outputFormat, uris, new ServerVersionAndEdition(neoServer));
    }

    DiscoveryService(Config config, OutputFormat outputFormat, DiscoverableURIs uris, ServerVersionAndEdition serverInfo) {
        this.config = config;
        this.outputFormat = outputFormat;
        this.uris = uris;
        this.serverInfo = serverInfo;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDiscoveryDocument(@Context UriInfo uriInfo) {
        return this.outputFormat.ok((Representation)new DiscoveryRepresentation(this.uris.update(uriInfo.getBaseUri()), this.serverInfo));
    }

    @GET
    @Produces(value={"*/*"})
    public Response redirectToBrowser() {
        return this.outputFormat.seeOther((URI)this.config.get(ServerSettings.browser_path));
    }
}

