/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.input.json;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.internal.util.Producer;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.input.json.StatementDeserializer;

@Provider
@Consumes(value={"application/json"})
public class JsonMessageBodyReader
implements MessageBodyReader<InputEventStream> {
    private static final String STATEMENTS_KEY = "input-statements";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(InputEventStream.class);
    }

    public InputEventStream readFrom(Class<InputEventStream> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        HashMap inputStatements = new HashMap();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(STATEMENTS_KEY, inputStatements);
        StatementDeserializer statementDeserializer = new StatementDeserializer(entityStream);
        return new InputEventStream(parameters, (Producer<Statement>)((Producer)() -> {
            InputStatement inputStatement = statementDeserializer.read();
            if (inputStatement == null) {
                return null;
            }
            Statement statement = new Statement(inputStatement.statement(), inputStatement.parameters());
            inputStatements.put(statement, inputStatement);
            return statement;
        }));
    }

    public static InputStatement getInputStatement(Map<String, Object> parameters, Statement statement) {
        if (!parameters.containsKey(STATEMENTS_KEY)) {
            return null;
        }
        Map inputStatements = (Map)parameters.get(STATEMENTS_KEY);
        return (InputStatement)inputStatements.get(statement);
    }
}

