/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

public class ServerSettings
implements SettingsDeclaration {
    @Description(value="Maximum request header size")
    @Internal
    public static final Setting<Integer> maximum_request_header_size = SettingImpl.newBuilder((String)"unsupported.dbms.max_http_request_header_size", (SettingValueParser)SettingValueParsers.INT, (Object)20480).build();
    @Description(value="Maximum response header size")
    @Internal
    public static final Setting<Integer> maximum_response_header_size = SettingImpl.newBuilder((String)"unsupported.dbms.max_http_response_header_size", (SettingValueParser)SettingValueParsers.INT, (Object)20480).build();
    @Description(value="Number of Neo4j worker threads. This setting is only valid for REST, and does not influence bolt-server. It sets the amount of worker threads for the Jetty server used by neo4j-server. This option can be tuned when you plan to execute multiple, concurrent REST requests, with the aim of getting more throughput from the database. Your OS might enforce a lower limit than the maximum value specified here.")
    @DocumentedDefaultValue(value="Number of available processors, or 500 for machines which have more than 500 processors.")
    public static final Setting<Integer> webserver_max_threads = SettingImpl.newBuilder((String)"dbms.threads.worker_count", (SettingValueParser)SettingValueParsers.INT, (Object)Math.min(Runtime.getRuntime().availableProcessors(), 500)).addConstraint(SettingConstraints.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(44738))).build();
    @Description(value="If execution time limiting is enabled in the database, this configures the maximum request execution time. Please use dbms.transaction.timeout instead.")
    @Internal
    @Deprecated
    public static final Setting<Duration> webserver_limit_execution_time = SettingImpl.newBuilder((String)"unsupported.dbms.executiontime_limit.time", (SettingValueParser)SettingValueParsers.DURATION, null).build();
    private static final SettingValueParser<ThirdPartyJaxRsPackage> MOUNT_POINTS = new SettingValueParser<ThirdPartyJaxRsPackage>(){

        public ThirdPartyJaxRsPackage parse(String packageAndMountpoint) {
            String[] parts = packageAndMountpoint.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("config for " + third_party_packages.name() + " is wrong: " + packageAndMountpoint);
            }
            String pkg = parts[0];
            String mountPoint = parts[1];
            return new ThirdPartyJaxRsPackage(pkg, mountPoint);
        }

        public String getDescription() {
            return "<classname>=<mount point> string";
        }

        public Class<ThirdPartyJaxRsPackage> getType() {
            return ThirdPartyJaxRsPackage.class;
        }
    };
    @Description(value="Comma-separated list of <classname>=<mount point> for unmanaged extensions.")
    public static final Setting<List<ThirdPartyJaxRsPackage>> third_party_packages = SettingImpl.newBuilder((String)"dbms.unmanaged_extension_classes", (SettingValueParser)SettingValueParsers.listOf(MOUNT_POINTS), Collections.emptyList()).build();
    @Description(value="Value of the Access-Control-Allow-Origin header sent over any HTTP or HTTPS connector. This defaults to '*', which allows broadest compatibility. Note that any URI provided here limits HTTP/HTTPS access to that URI only.")
    public static final Setting<String> http_access_control_allow_origin = SettingImpl.newBuilder((String)"dbms.security.http_access_control_allow_origin", (SettingValueParser)SettingValueParsers.STRING, (Object)"*").build();
    @Description(value="Enable HTTP request logging.")
    public static final Setting<Boolean> http_logging_enabled = SettingImpl.newBuilder((String)"dbms.logs.http.enabled", (SettingValueParser)SettingValueParsers.BOOL, (Object)false).build();
    @Description(value="Path to HTTP request log.")
    public static final Setting<Path> http_log_path = SettingImpl.newBuilder((String)"dbms.logs.http.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("http.log", new String[0])).setDependency(GraphDatabaseSettings.logs_directory).immutable().build();
    @Description(value="Number of HTTP logs to keep.")
    public static final Setting<Integer> http_logging_rotation_keep_number = SettingImpl.newBuilder((String)"dbms.logs.http.rotation.keep_number", (SettingValueParser)SettingValueParsers.INT, (Object)5).build();
    @Description(value="Size of each HTTP log that is kept.")
    public static final Setting<Long> http_logging_rotation_size = SettingImpl.newBuilder((String)"dbms.logs.http.rotation.size", (SettingValueParser)SettingValueParsers.BYTES, (Object)ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE))).build();
    @Description(value="Timeout for idle transactions in the REST endpoint.")
    public static final Setting<Duration> transaction_idle_timeout = SettingImpl.newBuilder((String)"dbms.rest.transaction.idle_timeout", (SettingValueParser)SettingValueParsers.DURATION, (Object)Duration.ofSeconds(60L)).build();
    @Description(value="Value of the HTTP Strict-Transport-Security (HSTS) response header. This header tells browsers that a webpage should only be accessed using HTTPS instead of HTTP. It is attached to every HTTPS response. Setting is not set by default so 'Strict-Transport-Security' header is not sent. Value is expected to contain directives like 'max-age', 'includeSubDomains' and 'preload'.")
    public static final Setting<String> http_strict_transport_security = SettingImpl.newBuilder((String)"dbms.security.http_strict_transport_security", (SettingValueParser)SettingValueParsers.STRING, null).build();
    @Description(value="Defines a whitelist of http paths where Neo4j authentication is not required.")
    public static final Setting<List<String>> http_auth_whitelist = SettingImpl.newBuilder((String)"dbms.security.http_auth_whitelist", (SettingValueParser)SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.STRING), List.of("/", "/browser.*")).build();
    @Internal
    @Description(value="Defines a blacklist of http paths that should not be accessed.")
    public static final Setting<List<String>> http_paths_blacklist = SettingImpl.newBuilder((String)"unsupported.dbms.http_paths_blacklist", (SettingValueParser)SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.STRING), Collections.emptyList()).build();
    @Internal
    @Description(value="Publicly discoverable bolt:// URI to use for Neo4j Drivers wanting to access the data in this particular database instance. Normally this is the same as the advertised address configured for the connector, but this allows manually overriding that default.")
    @DocumentedDefaultValue(value="Defaults to a bolt://-schemed version of the advertised address of the first found bolt connector.")
    public static final Setting<URI> bolt_discoverable_address = SettingImpl.newBuilder((String)"unsupported.dbms.discoverable_bolt_address", (SettingValueParser)SettingValueParsers.URI, (Object)((URI)SettingValueParsers.URI.parse(""))).build();
    @Internal
    @Description(value="Publicly discoverable neo4j:// URI to use for Neo4j Drivers wanting to access a cluster or a single instance.")
    @DocumentedDefaultValue(value="Defaults to empty on any deployment that is not a causal cluster core, and a neo4j://-schemed URI of the advertised address of the bolt connector.")
    public static final Setting<URI> bolt_routing_discoverable_address = SettingImpl.newBuilder((String)"unsupported.dbms.discoverable_bolt_routing_address", (SettingValueParser)SettingValueParsers.URI, (Object)((URI)SettingValueParsers.URI.parse(""))).build();
    @Description(value="Commands to be run when Neo4j Browser successfully connects to this server. Separate multiple commands with semi-colon.")
    public static final Setting<String> browser_postConnectCmd = SettingImpl.newBuilder((String)"browser.post_connect_cmd", (SettingValueParser)SettingValueParsers.STRING, (Object)"").build();
    @Description(value="Whitelist of hosts for the Neo4j Browser to be allowed to fetch content from.")
    public static final Setting<String> browser_remoteContentHostnameWhitelist = SettingImpl.newBuilder((String)"browser.remote_content_hostname_whitelist", (SettingValueParser)SettingValueParsers.STRING, (Object)"guides.neo4j.com,localhost").build();
    @Internal
    @Description(value="The legacy data endpoint. This is kept for back-compatibility purpose.")
    public static final Setting<URI> rest_api_path = SettingImpl.newBuilder((String)"unsupported.dbms.uris.rest", (SettingValueParser)SettingValueParsers.NORMALIZED_RELATIVE_URI, (Object)((URI)SettingValueParsers.NORMALIZED_RELATIVE_URI.parse("/db/data"))).build();
    @Internal
    @Description(value="The legacy manage endpoint. This is kept for back-compatibility purpose.")
    public static final Setting<URI> management_api_path = SettingImpl.newBuilder((String)"unsupported.dbms.uris.management", (SettingValueParser)SettingValueParsers.NORMALIZED_RELATIVE_URI, (Object)((URI)SettingValueParsers.NORMALIZED_RELATIVE_URI.parse("/db/manage"))).build();
    @Internal
    @Description(value="The start endpoint of database api.")
    public static final Setting<URI> db_api_path = SettingImpl.newBuilder((String)"unsupported.dbms.uris.db", (SettingValueParser)SettingValueParsers.NORMALIZED_RELATIVE_URI, (Object)((URI)SettingValueParsers.NORMALIZED_RELATIVE_URI.parse("/db"))).build();
    @Internal
    public static final Setting<URI> browser_path = SettingImpl.newBuilder((String)"unsupported.dbms.uris.browser", (SettingValueParser)SettingValueParsers.URI, (Object)((URI)SettingValueParsers.URI.parse("/browser/"))).build();
    @Internal
    public static final Setting<Boolean> wadl_enabled = SettingImpl.newBuilder((String)"unsupported.dbms.wadl_generation_enabled", (SettingValueParser)SettingValueParsers.BOOL, (Object)false).build();
}

