/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import javax.ws.rs.core.Response;

public class CustomStatusType
implements Response.StatusType {
    public static final Response.StatusType UNPROCESSABLE = new CustomStatusType(422, "Unprocessable Entity");
    private final int code;
    private final String reason;
    private final Response.Status.Family family;

    public CustomStatusType(int code, String reason) {
        this.code = code;
        this.reason = reason;
        switch (code / 100) {
            case 1: {
                this.family = Response.Status.Family.INFORMATIONAL;
                break;
            }
            case 2: {
                this.family = Response.Status.Family.SUCCESSFUL;
                break;
            }
            case 3: {
                this.family = Response.Status.Family.REDIRECTION;
                break;
            }
            case 4: {
                this.family = Response.Status.Family.CLIENT_ERROR;
                break;
            }
            case 5: {
                this.family = Response.Status.Family.SERVER_ERROR;
                break;
            }
            default: {
                this.family = Response.Status.Family.OTHER;
            }
        }
    }

    public int getStatusCode() {
        return this.code;
    }

    public Response.Status.Family getFamily() {
        return this.family;
    }

    public String getReasonPhrase() {
        return this.reason;
    }
}

