/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;

public class DiscoverableURIs {
    private final Collection<URIEntry> entries;

    private DiscoverableURIs(Collection<URIEntry> entries) {
        this.entries = entries;
    }

    public void forEach(BiConsumer<String, URI> consumer) {
        this.entries.stream().collect(Collectors.groupingBy(e -> ((URIEntry)e).key)).forEach((? super K key, ? super V list) -> list.stream().max(Comparator.comparing(e -> ((URIEntry)e).precedence)).ifPresent(e -> consumer.accept((String)key, ((URIEntry)e).uri)));
    }

    public static class Builder {
        private final Collection<URIEntry> entries;

        public Builder() {
            this.entries = new ArrayList<URIEntry>();
        }

        public Builder(DiscoverableURIs copy) {
            this.entries = new ArrayList<URIEntry>(copy.entries);
        }

        public Builder add(String key, URI uri, Precedence precedence) {
            if (this.entries.stream().anyMatch(e -> ((URIEntry)e).key.equals(key) && ((URIEntry)e).precedence == precedence)) {
                throw new InvalidSettingException(String.format("Unable to add two entries with the same precedence using key '%s' and precedence '%s'", new Object[]{key, precedence}));
            }
            this.entries.add(new URIEntry(key, uri, precedence));
            return this;
        }

        public Builder add(String key, String uri, Precedence precedence) {
            try {
                return this.add(key, new URI(uri), precedence);
            }
            catch (URISyntaxException e) {
                throw new InvalidSettingException(String.format("Unable to construct bolt discoverable URI using '%s' as uri: %s", uri, e.getMessage()), (Throwable)e);
            }
        }

        public Builder add(String key, String scheme, String hostname, int port, Precedence precedence) {
            try {
                return this.add(key, new URI(scheme, null, hostname, port, null, null, null), precedence);
            }
            catch (URISyntaxException e) {
                throw new InvalidSettingException(String.format("Unable to construct bolt discoverable URI using '%s' as hostname: %s", hostname, e.getMessage()), (Throwable)e);
            }
        }

        public Builder addBoltConnectorFromConfig(String key, String scheme, Config config, Setting<URI> override, ConnectorPortRegister portRegister) {
            if (config.isConfigured(override)) {
                this.add(key, (URI)config.get(override), Precedence.HIGHEST);
            }
            config.enabledBoltConnectors().stream().findFirst().ifPresent(c -> {
                AdvertisedSocketAddress address = (AdvertisedSocketAddress)config.get(c.advertised_address);
                int port = address.getPort();
                if (port == 0) {
                    port = portRegister.getLocalAddress(c.key()).getPort();
                }
                this.add(key, scheme, address.getHostname(), port, config.isConfigured(c.advertised_address) ? Precedence.HIGH : Precedence.LOWEST);
            });
            return this;
        }

        public Builder overrideAbsolutesFromRequest(URI requestUri) {
            List defaultEntries = this.entries.stream().filter(e -> ((URIEntry)e).uri.isAbsolute() && ((URIEntry)e).precedence == Precedence.LOWEST).collect(Collectors.toList());
            for (URIEntry entry : defaultEntries) {
                this.add(entry.key, entry.uri.getScheme(), requestUri.getHost(), entry.uri.getPort(), Precedence.LOW);
            }
            return this;
        }

        public DiscoverableURIs build() {
            return new DiscoverableURIs(this.entries);
        }
    }

    private static class URIEntry {
        private String key;
        private Precedence precedence;
        private URI uri;

        private URIEntry(String key, URI uri, Precedence precedence) {
            this.key = key;
            this.uri = uri;
            this.precedence = precedence;
        }
    }

    public static enum Precedence {
        LOWEST,
        LOW,
        NORMAL,
        HIGH,
        HIGHEST;

    }
}

