/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/")
public class DiscoveryService {
    private final Config config;
    private final OutputFormat outputFormat;
    private final DiscoverableURIs uris;
    private final Map<String, Object> varyHeader;

    public DiscoveryService(@Context Config config, @Context OutputFormat outputFormat, @Context DiscoverableURIs uris) {
        this.config = config;
        this.outputFormat = outputFormat;
        this.uris = uris;
        this.varyHeader = Collections.singletonMap("Vary", "Accept");
    }

    Response getDiscoveryDocument(UriInfo uriInfo) {
        return this.outputFormat.ok((Representation)new DiscoveryRepresentation(new DiscoverableURIs.Builder(this.uris).overrideAbsolutesFromRequest(uriInfo.getBaseUri()).build()));
    }

    @GET
    @Produces(value={"*/*"})
    public Response get(@Context Request request, @Context UriInfo uriInfo) {
        Variant v = request.selectVariant(Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_HTML_TYPE}).add().build());
        if (v == null) {
            return Response.serverError().status(Response.Status.NOT_ACCEPTABLE).build();
        }
        if (v.getMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            return this.getDiscoveryDocument(uriInfo);
        }
        return this.outputFormat.seeOther((URI)this.config.get(ServerSettings.browser_path), this.varyHeader);
    }
}

