/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;

public class HttpsRequestCustomizer
implements HttpConfiguration.Customizer {
    private final HttpField hstsResponseField;

    public HttpsRequestCustomizer(Config config) {
        this.hstsResponseField = HttpsRequestCustomizer.createHstsResponseField(config);
    }

    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        request.setScheme(HttpScheme.HTTPS.asString());
        HttpsRequestCustomizer.addResponseFieldIfConfigured(request, this.hstsResponseField);
    }

    private static void addResponseFieldIfConfigured(Request request, HttpField field) {
        if (field != null) {
            request.getResponse().getHttpFields().add(field);
        }
    }

    private static HttpField createHstsResponseField(Config config) {
        String configuredValue = (String)config.get(ServerSettings.http_strict_transport_security);
        if (StringUtils.isBlank((CharSequence)configuredValue)) {
            return null;
        }
        return new PreEncodedHttpField(HttpHeader.STRICT_TRANSPORT_SECURITY, configuredValue);
    }
}

