/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.Arrays;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.web.JettyHttpConnectionFactory;
import org.neo4j.server.web.JettyThreadCalculator;

public class HttpConnectorFactory {
    private static final String NAME = "http";
    private final String name;
    private final NetworkConnectionTracker connectionTracker;
    private final Config configuration;

    public HttpConnectorFactory(NetworkConnectionTracker connectionTracker, Config config) {
        this(NAME, connectionTracker, config);
    }

    protected HttpConnectorFactory(String name, NetworkConnectionTracker connectionTracker, Config configuration) {
        this.name = name;
        this.connectionTracker = connectionTracker;
        this.configuration = configuration;
    }

    public ConnectionFactory createHttpConnectionFactory() {
        return new JettyHttpConnectionFactory(this.connectionTracker, this.createHttpConfig());
    }

    protected HttpConfiguration createHttpConfig() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(((Integer)this.configuration.get(ServerSettings.maximum_request_header_size)).intValue());
        httpConfig.setResponseHeaderSize(((Integer)this.configuration.get(ServerSettings.maximum_response_header_size)).intValue());
        httpConfig.setSendServerVersion(false);
        return httpConfig;
    }

    public ServerConnector createConnector(Server server, ListenSocketAddress address, JettyThreadCalculator jettyThreadCalculator) {
        ConnectionFactory httpFactory = this.createHttpConnectionFactory();
        return this.createConnector(server, address, jettyThreadCalculator, httpFactory);
    }

    public ServerConnector createConnector(Server server, ListenSocketAddress address, JettyThreadCalculator jettyThreadCalculator, ConnectionFactory ... httpFactories) {
        int acceptors = jettyThreadCalculator.getAcceptors();
        int selectors = jettyThreadCalculator.getSelectors();
        ServerConnector connector = new ServerConnector(server, null, null, null, acceptors, selectors, httpFactories);
        connector.setName(this.name);
        connector.setConnectionFactories(Arrays.asList(httpFactories));
        connector.setAcceptQueueSize(50);
        connector.setHost(address.getHostname());
        connector.setPort(address.getPort());
        return connector;
    }
}

