/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationFormat;

public class UrlFormFormat
extends RepresentationFormat {
    public UrlFormFormat() {
        super(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    protected String serializeValue(String type, Object value) {
        throw new RuntimeException("Not implemented!");
    }

    protected ListWriter serializeList(String type) {
        throw new RuntimeException("Not implemented!");
    }

    protected MappingWriter serializeMapping(String type) {
        throw new RuntimeException("Not implemented!");
    }

    protected String complete(ListWriter serializer) {
        throw new RuntimeException("Not implemented!");
    }

    protected String complete(MappingWriter serializer) {
        throw new RuntimeException("Not implemented!");
    }

    public Object readValue(String input) {
        throw new RuntimeException("Not implemented!");
    }

    public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (input.isEmpty()) {
            return result;
        }
        for (String pair : input.split("&")) {
            ArrayList<Object> list;
            String value;
            String key;
            String[] fields = pair.split("=");
            try {
                String charset = StandardCharsets.UTF_8.name();
                key = this.ensureThatKeyDoesNotHavePhPStyleParenthesesAtTheEnd(URLDecoder.decode(fields[0], charset));
                value = URLDecoder.decode(fields[1], charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new BadInputException((Throwable)e);
            }
            Object old = result.get(key);
            if (old == null) {
                result.put(key, value);
                continue;
            }
            if (old instanceof List) {
                list = (ArrayList<Object>)old;
            } else {
                list = new ArrayList<Object>();
                result.put(key, list);
                list.add(old);
            }
            list.add(value);
        }
        return DefaultFormat.validateKeys(result, requiredKeys);
    }

    private String ensureThatKeyDoesNotHavePhPStyleParenthesesAtTheEnd(String key) {
        if (key.endsWith("[]")) {
            return key.substring(0, key.length() - 2);
        }
        return key;
    }

    public List<Object> readList(String input) {
        throw new RuntimeException("Not implemented!");
    }

    public URI readUri(String input) {
        throw new RuntimeException("Not implemented!");
    }
}

