/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.server.rest.domain.RelationshipDirection;

public class RelationshipExpanderBuilder {
    private RelationshipExpanderBuilder() {
    }

    public static PathExpander describeRelationships(Map<String, Object> description) {
        PathExpanderBuilder expander = PathExpanderBuilder.allTypesAndDirections();
        Object relationshipsDescription = description.get("relationships");
        if (relationshipsDescription != null) {
            List<Object> pairDescriptions = relationshipsDescription instanceof Collection ? (List<Object>)relationshipsDescription : Arrays.asList(relationshipsDescription);
            for (Object e : pairDescriptions) {
                Map map = (Map)e;
                String name = (String)map.get("type");
                RelationshipType type = RelationshipType.withName((String)name);
                String directionName = (String)map.get("direction");
                expander = directionName == null ? expander.add(type) : expander.add(type, RelationshipExpanderBuilder.stringToEnum((String)directionName, RelationshipDirection.class, (boolean)true).internal);
            }
        }
        return expander.build();
    }

    private static <T extends Enum<T>> T stringToEnum(String name, Class<T> enumClass, boolean fuzzyMatch) {
        if (name == null) {
            return null;
        }
        for (Enum candidate : (Enum[])enumClass.getEnumConstants()) {
            if (!candidate.name().equals(name)) continue;
            return (T)candidate;
        }
        if (fuzzyMatch) {
            for (Enum candidate : (Enum[])enumClass.getEnumConstants()) {
                if (!candidate.name().startsWith(name)) continue;
                return (T)candidate;
            }
        }
        throw new RuntimeException("Unrecognized " + enumClass.getSimpleName() + " '" + name + "'");
    }
}

