/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.modules.AuthorizationModule;
import org.neo4j.server.modules.ConsoleModule;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.modules.Neo4jBrowserModule;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.SecurityRulesModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.management.JmxService;
import org.neo4j.server.rest.management.console.ConsoleService;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;
import org.neo4j.udc.UsageData;

public class CommunityNeoServer
extends AbstractNeoServer {
    public CommunityNeoServer(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this(config, new CommunityGraphFactory(), dependencies);
    }

    public CommunityNeoServer(Config config, GraphFactory graphFactory, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        super(config, graphFactory, dependencies);
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        return Arrays.asList(this.createDBMSModule(), new RESTApiModule(this.webServer, this.getConfig(), this.getDependencyResolver().provideDependency(UsageData.class), this.userLogProvider), new ManagementApiModule(this.webServer, this.getConfig()), new ThirdPartyJAXRSModule(this.webServer, this.getConfig(), this.userLogProvider, this), new ConsoleModule(this.webServer, this.getConfig()), new Neo4jBrowserModule(this.webServer), this.createAuthorizationModule(), new SecurityRulesModule(this.webServer, this.getConfig(), this.userLogProvider));
    }

    @Override
    protected WebServer createWebServer() {
        NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)this.getDependencyResolver().resolveDependency(NetworkConnectionTracker.class);
        return new Jetty9WebServer(this.userLogProvider, this.getConfig(), connectionTracker);
    }

    @Override
    public Iterable<AdvertisableService> getServices() {
        ArrayList<AdvertisableService> toReturn = new ArrayList<AdvertisableService>(3);
        toReturn.add(new ConsoleService(null, null, this.userLogProvider, null));
        toReturn.add(new JmxService(null, null));
        return toReturn;
    }

    protected DBMSModule createDBMSModule() {
        Supplier<DiscoverableURIs> discoverableURIs = () -> CommunityDiscoverableURIs.communityDiscoverableURIs(this.getConfig(), (ConnectorPortRegister)this.getDependencyResolver().resolveDependency(ConnectorPortRegister.class));
        return new DBMSModule(this.webServer, this.getConfig(), discoverableURIs);
    }

    protected AuthorizationModule createAuthorizationModule() {
        return new AuthorizationModule(this.webServer, this.authManagerSupplier, this.userLogProvider, this.getConfig(), this.getUriWhitelist());
    }
}

