/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

class TransitionalTxManagementKernelTransaction {
    private final GraphDatabaseFacade db;
    private final Transaction.Type type;
    private final LoginContext loginContext;
    private long customTransactionTimeout;
    private final ThreadToStatementContextBridge bridge;
    private InternalTransaction tx;
    private KernelTransaction suspendedTransaction;

    TransitionalTxManagementKernelTransaction(GraphDatabaseFacade db, Transaction.Type type, LoginContext loginContext, long customTransactionTimeout, ThreadToStatementContextBridge bridge) {
        this.db = db;
        this.type = type;
        this.loginContext = loginContext;
        this.customTransactionTimeout = customTransactionTimeout;
        this.bridge = bridge;
        this.tx = this.startTransaction();
    }

    void suspendSinceTransactionsAreStillThreadBound() {
        assert (this.suspendedTransaction == null) : "Can't suspend the transaction if it already is suspended.";
        this.suspendedTransaction = this.bridge.getKernelTransactionBoundToThisThread(true);
        this.bridge.unbindTransactionFromCurrentThread();
    }

    void resumeSinceTransactionsAreStillThreadBound() {
        assert (this.suspendedTransaction != null) : "Can't resume the transaction if it has not first been suspended.";
        this.bridge.bindTransactionToCurrentThread(this.suspendedTransaction);
        this.suspendedTransaction = null;
    }

    public void terminate() {
        this.tx.terminate();
    }

    public void rollback() {
        try {
            KernelTransaction kernelTransactionBoundToThisThread = this.bridge.getKernelTransactionBoundToThisThread(false);
            kernelTransactionBoundToThisThread.failure();
            kernelTransactionBoundToThisThread.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.bridge.unbindTransactionFromCurrentThread();
        }
    }

    public void commit() {
        try {
            KernelTransaction kernelTransactionBoundToThisThread = this.bridge.getKernelTransactionBoundToThisThread(true);
            kernelTransactionBoundToThisThread.success();
            kernelTransactionBoundToThisThread.close();
        }
        catch (NotInTransactionException kernelTransactionBoundToThisThread) {
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.bridge.unbindTransactionFromCurrentThread();
        }
    }

    void closeTransactionForPeriodicCommit() {
        this.tx.close();
    }

    void reopenAfterPeriodicCommit() {
        this.tx = this.startTransaction();
    }

    private InternalTransaction startTransaction() {
        return this.customTransactionTimeout > 0L ? this.db.beginTransaction(this.type, this.loginContext, this.customTransactionTimeout, TimeUnit.MILLISECONDS) : this.db.beginTransaction(this.type, this.loginContext);
    }
}

