/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.SocketAddress;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;

public class JettyHttpConnection
extends HttpConnection
implements TrackedNetworkConnection {
    private final String id;
    private final long connectTime;
    private volatile String user;

    public JettyHttpConnection(String id, HttpConfiguration config, Connector connector, EndPoint endPoint, HttpCompliance compliance, boolean recordComplianceViolations) {
        super(config, connector, endPoint, compliance, recordComplianceViolations);
        this.id = id;
        this.connectTime = System.currentTimeMillis();
    }

    public String id() {
        return this.id;
    }

    public long connectTime() {
        return this.connectTime;
    }

    public String connector() {
        return this.getConnector().getName();
    }

    public SocketAddress serverAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public SocketAddress clientAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public String user() {
        return this.user;
    }

    public void updateUser(String user) {
        this.user = user;
    }

    public static void updateUserForCurrentConnection(String user) {
        HttpConnection currentConnection = HttpConnection.getCurrentConnection();
        if (currentConnection instanceof JettyHttpConnection) {
            ((JettyHttpConnection)currentConnection).updateUser(user);
        }
    }
}

