/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.logging.Log;
import org.neo4j.server.database.Database;

public class LifecycleManagingDatabase
implements Database {
    static final String CYPHER_WARMUP_QUERY = "MATCH (a:` This query is just used to load the cypher compiler during warmup. Please ignore `) RETURN a LIMIT 0";
    private final Config config;
    private final GraphFactory dbFactory;
    private final GraphDatabaseFacadeFactory.Dependencies dependencies;
    private final Log log;
    private boolean isRunning;
    private GraphDatabaseFacade graph;

    public static Database.Factory lifecycleManagingDatabase(GraphFactory graphDbFactory) {
        return (config, dependencies) -> new LifecycleManagingDatabase(config, graphDbFactory, dependencies);
    }

    public LifecycleManagingDatabase(Config config, GraphFactory dbFactory, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this.config = config;
        this.dbFactory = dbFactory;
        this.dependencies = dependencies;
        this.log = dependencies.userLogProvider().getLog(this.getClass());
    }

    @Override
    public File getLocation() {
        return (File)this.config.get(GraphDatabaseSettings.database_path);
    }

    @Override
    public GraphDatabaseFacade getGraph() {
        return this.graph;
    }

    public void init() {
    }

    public void start() {
        this.log.info("Starting...");
        this.graph = this.dbFactory.newGraphDatabase(this.config, this.dependencies);
        if (!this.isInTestMode()) {
            this.preLoadCypherCompiler();
        }
        this.isRunning = true;
        this.log.info("Started.");
    }

    public void stop() {
        if (this.graph != null) {
            this.log.info("Stopping...");
            this.graph.shutdown();
            this.isRunning = false;
            this.graph = null;
            this.log.info("Stopped.");
        }
    }

    public void shutdown() {
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    private void preLoadCypherCompiler() {
        try {
            Result ignore = this.graph.execute(CYPHER_WARMUP_QUERY);
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isInTestMode() {
        boolean testing = false;
        if (!$assertionsDisabled) {
            testing = true;
            if (!true) {
                throw new AssertionError((Object)"yes, this should be an assignment!");
            }
        }
        return testing;
    }

    public static interface GraphFactory {
        public GraphDatabaseFacade newGraphDatabase(Config var1, GraphDatabaseFacadeFactory.Dependencies var2);
    }
}

