/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.neo4j.server.Bootstrapper;

public class BlockingBootstrapper
implements Bootstrapper {
    private final Bootstrapper wrapped;
    private final CountDownLatch latch;

    public BlockingBootstrapper(Bootstrapper wrapped) {
        this.wrapped = wrapped;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public final int start(File homeDir, Optional<File> configFile, Map<String, String> configOverrides) {
        int status = this.wrapped.start(homeDir, configFile, configOverrides);
        if (status != 0) {
            return status;
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.wrapped.stop();
    }

    @Override
    public int stop() {
        this.latch.countDown();
        return 0;
    }
}

