/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.WrapFactory;
import org.neo4j.server.rest.web.ScriptExecutionMode;
import org.neo4j.server.scripting.UserScriptClassWhiteList;
import org.neo4j.server.scripting.javascript.WhiteListClassShutter;
import org.neo4j.server.scripting.javascript.WhiteListJavaWrapper;

public class GlobalJavascriptInitializer {
    private static ScriptExecutionMode initializationMode;

    private GlobalJavascriptInitializer() {
    }

    public static synchronized void initialize(ScriptExecutionMode executionMode) {
        if (initializationMode != null) {
            if (initializationMode == executionMode) {
                return;
            }
            throw new RuntimeException("Cannot initialize javascript context twice, system is currently initialized as: '" + initializationMode.name() + "'.");
        }
        initializationMode = executionMode;
        if (executionMode == ScriptExecutionMode.UNRESTRICTED) {
            ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

                protected Context makeContext() {
                    Context cx = super.makeContext();
                    cx.setLanguageVersion(170);
                    cx.setOptimizationLevel(4);
                    return cx;
                }
            });
        } else if (executionMode == ScriptExecutionMode.SANDBOXED) {
            ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

                protected Context makeContext() {
                    Context cx = super.makeContext();
                    cx.setLanguageVersion(170);
                    cx.setOptimizationLevel(4);
                    WhiteListClassShutter shutter = new WhiteListClassShutter(UserScriptClassWhiteList.getWhiteList());
                    cx.setClassShutter((ClassShutter)shutter);
                    cx.setWrapFactory((WrapFactory)new WhiteListJavaWrapper(shutter));
                    return cx;
                }
            });
        }
    }
}

