/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.repr.RepresentationWriteHandler;

@Path(value="/relationship/types")
public class DatabaseMetadataService {
    private final Database database;
    private RepresentationWriteHandler representationWriteHandler = RepresentationWriteHandler.DO_NOTHING;

    public DatabaseMetadataService(@Context Database database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    public Response getRelationshipTypes(@QueryParam(value="in_use") @DefaultValue(value="true") boolean inUse) {
        try {
            GraphDatabaseFacade db = this.database.getGraph();
            ResourceIterable relationshipTypes = inUse ? db.getAllRelationshipTypesInUse() : db.getAllRelationshipTypes();
            Response response = Response.ok().type("application/json").entity((Object)this.generateJsonRepresentation((Iterable<RelationshipType>)relationshipTypes)).build();
            return response;
        }
        finally {
            this.representationWriteHandler.onRepresentationFinal();
        }
    }

    private String generateJsonRepresentation(Iterable<RelationshipType> relationshipTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (RelationshipType rt : relationshipTypes) {
            sb.append("\"");
            sb.append(rt.name());
            sb.append("\",");
        }
        sb.append("]");
        return sb.toString().replaceAll(",]", "]");
    }

    public void setRepresentationWriteHandler(RepresentationWriteHandler representationWriteHandler) {
        this.representationWriteHandler = representationWriteHandler;
    }
}

