/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.web.HttpHeaderUtils;
import org.neo4j.server.web.HttpMethod;

public class CorsFilter
implements Filter {
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private final Log log;

    public CorsFilter(LogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Enumeration requestHeaderEnumeration;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        Enumeration requestMethodEnumeration = request.getHeaders(ACCESS_CONTROL_REQUEST_METHOD);
        if (requestMethodEnumeration != null) {
            while (requestMethodEnumeration.hasMoreElements()) {
                String requestMethod = (String)requestMethodEnumeration.nextElement();
                this.addAllowedMethodIfValid(requestMethod, response);
            }
        }
        if ((requestHeaderEnumeration = request.getHeaders(ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            while (requestHeaderEnumeration.hasMoreElements()) {
                String requestHeader = (String)requestHeaderEnumeration.nextElement();
                this.addAllowedHeaderIfValid(requestHeader, response);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    private void addAllowedMethodIfValid(String methodName, HttpServletResponse response) {
        HttpMethod method = HttpMethod.valueOfOrNull(methodName);
        if (method != null) {
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, methodName);
        } else {
            this.log.warn("Unknown HTTP method specified in Access-Control-Request-Method '" + methodName + "'. It will be ignored and not attached to the " + ACCESS_CONTROL_ALLOW_METHODS + " response header");
        }
    }

    private void addAllowedHeaderIfValid(String headerName, HttpServletResponse response) {
        if (HttpHeaderUtils.isValidHttpHeaderName(headerName)) {
            response.addHeader(ACCESS_CONTROL_ALLOW_HEADERS, headerName);
        } else {
            this.log.warn("Invalid HTTP header specified in Access-Control-Request-Headers '" + headerName + "'. It will be ignored and not attached to the " + ACCESS_CONTROL_ALLOW_HEADERS + " response header");
        }
    }
}

