/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.batch;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.server.rest.web.InternalJettyServletRequest;
import org.neo4j.server.rest.web.InternalJettyServletResponse;
import org.neo4j.server.web.WebServer;

public abstract class BatchOperations {
    private static final Pattern PLACHOLDER_PATTERN = Pattern.compile("\\{(\\d{1,10})}");
    protected static final String ID_KEY = "id";
    protected static final String METHOD_KEY = "method";
    protected static final String BODY_KEY = "body";
    protected static final String TO_KEY = "to";
    protected static final JsonFactory jsonFactory = new JsonFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    protected final WebServer webServer;
    protected final ObjectMapper mapper;

    public BatchOperations(WebServer webServer) {
        this.webServer = webServer;
        this.mapper = new ObjectMapper();
    }

    protected void addHeaders(InternalJettyServletRequest res, HttpHeaders httpHeaders) {
        for (Map.Entry header : httpHeaders.getRequestHeaders().entrySet()) {
            String key = (String)header.getKey();
            List value = (List)header.getValue();
            if (value == null) continue;
            if (value.size() != 1) {
                throw new IllegalArgumentException("expecting one value per header");
            }
            if (key.equals("Accept") || key.equals("Content-Type")) continue;
            res.addHeader(key, (String)value.get(0));
        }
        res.addHeader("Accept", "application/json");
        res.addHeader("Content-Type", "application/json");
    }

    protected URI calculateTargetUri(UriInfo serverUriInfo, String requestedPath) {
        URI baseUri = serverUriInfo.getBaseUri();
        if (requestedPath.startsWith(baseUri.toString())) {
            requestedPath = requestedPath.substring(baseUri.toString().length());
        }
        if (!requestedPath.startsWith("/")) {
            requestedPath = "/" + requestedPath;
        }
        return baseUri.resolve("." + requestedPath);
    }

    protected String replaceLocationPlaceholders(String str, Map<Integer, String> locations) {
        if (!str.contains("{")) {
            return str;
        }
        Matcher matcher = PLACHOLDER_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        String replacement = null;
        while (matcher.find()) {
            String id = matcher.group(1);
            try {
                replacement = locations.get(Integer.valueOf(id));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (replacement != null) {
                matcher.appendReplacement(sb, replacement);
                continue;
            }
            matcher.appendReplacement(sb, matcher.group());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected boolean is2XXStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    protected void parseAndPerform(UriInfo uriInfo, HttpHeaders httpHeaders, HttpServletRequest req, InputStream body, Map<Integer, String> locations) throws IOException, ServletException {
        JsonToken token;
        JsonParser jp = jsonFactory.createJsonParser(body);
        InternalJettyServletRequest.RequestData requestData = InternalJettyServletRequest.RequestData.from(req);
        while ((token = jp.nextToken()) != null) {
            if (token != JsonToken.START_OBJECT) continue;
            String jobMethod = "";
            String jobPath = "";
            String jobBody = "";
            Integer jobId = null;
            while ((token = jp.nextToken()) != JsonToken.END_OBJECT && token != null) {
                String field = jp.getText();
                jp.nextToken();
                switch (field) {
                    case "method": {
                        jobMethod = jp.getText().toUpperCase();
                        break;
                    }
                    case "to": {
                        jobPath = jp.getText();
                        break;
                    }
                    case "id": {
                        jobId = jp.getIntValue();
                        break;
                    }
                    case "body": {
                        jobBody = this.readBody(jp);
                        break;
                    }
                }
            }
            this.performRequest(uriInfo, jobMethod, jobPath, jobBody, jobId, httpHeaders, locations, requestData);
        }
    }

    private String readBody(JsonParser jp) throws IOException {
        JsonNode node = this.mapper.readTree(jp);
        StringWriter out = new StringWriter();
        JsonGenerator gen = jsonFactory.createJsonGenerator((Writer)out);
        this.mapper.writeTree(gen, node);
        gen.flush();
        gen.close();
        return out.toString();
    }

    protected void performRequest(UriInfo uriInfo, String method, String path, String body, Integer id, HttpHeaders httpHeaders, Map<Integer, String> locations, InternalJettyServletRequest.RequestData requestData) throws IOException, ServletException {
        path = this.replaceLocationPlaceholders(path, locations);
        body = this.replaceLocationPlaceholders(body, locations);
        URI targetUri = this.calculateTargetUri(uriInfo, path);
        InternalJettyServletResponse res = new InternalJettyServletResponse();
        InternalJettyServletRequest req = new InternalJettyServletRequest(method, targetUri.toString(), body, res, requestData);
        this.addHeaders(req, httpHeaders);
        this.invoke(method, path, body, id, targetUri, req, res);
    }

    protected abstract void invoke(String var1, String var2, String var3, Integer var4, URI var5, InternalJettyServletRequest var6, InternalJettyServletResponse var7) throws IOException, ServletException;
}

