/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.RunCarefully;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.LoggingProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerProvider;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.CypherExecutorProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseProvider;
import org.neo4j.server.database.GraphDatabaseServiceProvider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.exception.ServerStartupErrors;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.ConfigAdapter;
import org.neo4j.server.plugins.PluginInvocatorProvider;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionFilter;
import org.neo4j.server.rest.transactional.TransactionHandleRegistry;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.web.AsyncRequestLog;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.web.WebServerProvider;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.time.Clocks;
import org.neo4j.udc.UsageData;

public abstract class AbstractNeoServer
implements NeoServer {
    private static final long MINIMUM_TIMEOUT = 1000L;
    private static final long ROUNDING_SECOND = 1000L;
    private static final Pattern[] DEFAULT_URI_WHITELIST = new Pattern[]{Pattern.compile("/browser.*"), Pattern.compile("/")};
    public static final String NEO4J_IS_STARTING_MESSAGE = "======== Neo4j " + Version.getNeo4jVersion() + " ========";
    private final Database.Factory dbFactory;
    private final GraphDatabaseFacadeFactory.Dependencies dependencies;
    protected final LogProvider logProvider;
    protected final Log log;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private final Config config;
    private final LifeSupport life = new LifeSupport();
    private final ListenSocketAddress httpListenAddress;
    private final Optional<ListenSocketAddress> httpsListenAddress;
    private AdvertisedSocketAddress httpAdvertisedAddress;
    private Optional<AdvertisedSocketAddress> httpsAdvertisedAddress;
    protected Database database;
    protected CypherExecutor cypherExecutor;
    protected WebServer webServer;
    protected Supplier<AuthManager> authManagerSupplier;
    protected Supplier<UserManagerSupplier> userManagerSupplier;
    protected Supplier<SslPolicyLoader> sslPolicyFactorySupplier;
    private DatabaseActions databaseActions;
    private TransactionFacade transactionFacade;
    private TransactionHandleRegistry transactionRegistry;
    private boolean initialized;
    private LifecycleAdapter serverComponents;
    protected ConnectorPortRegister connectorPortRegister;
    private HttpConnector httpConnector;
    private Optional<HttpConnector> httpsConnector;
    private final Dependencies dependencyResolver = new Dependencies((Supplier)new Supplier<DependencyResolver>(){

        @Override
        public DependencyResolver get() {
            Database db = (Database)AbstractNeoServer.this.dependencyResolver.resolveDependency(Database.class);
            return db.getGraph().getDependencyResolver();
        }
    });

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract WebServer createWebServer();

    public AbstractNeoServer(Config config, Database.Factory dbFactory, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        this.config = config;
        this.dbFactory = dbFactory;
        this.dependencies = dependencies;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.log.info(NEO4J_IS_STARTING_MESSAGE);
        List httpConnectors = config.enabledHttpConnectors();
        this.httpConnector = httpConnectors.stream().filter(c -> HttpConnector.Encryption.NONE.equals((Object)c.encryptionLevel())).findFirst().orElseThrow(() -> new IllegalArgumentException("An HTTP connector must be configured to run the server"));
        this.httpListenAddress = (ListenSocketAddress)config.get(this.httpConnector.listen_address);
        this.httpAdvertisedAddress = (AdvertisedSocketAddress)config.get(this.httpConnector.advertised_address);
        this.httpsConnector = httpConnectors.stream().filter(c -> HttpConnector.Encryption.TLS.equals((Object)c.encryptionLevel())).findFirst();
        this.httpsListenAddress = this.httpsConnector.map(connector -> (ListenSocketAddress)config.get(connector.listen_address));
        this.httpsAdvertisedAddress = this.httpsConnector.map(connector -> (AdvertisedSocketAddress)config.get(connector.advertised_address));
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.database = (Database)this.life.add((Lifecycle)this.dependencyResolver.satisfyDependency((Object)this.dbFactory.newDatabase(this.config, this.dependencies)));
        this.authManagerSupplier = this.dependencyResolver.provideDependency(AuthManager.class);
        this.userManagerSupplier = this.dependencyResolver.provideDependency(UserManagerSupplier.class);
        this.sslPolicyFactorySupplier = this.dependencyResolver.provideDependency(SslPolicyLoader.class);
        this.webServer = this.createWebServer();
        for (ServerModule moduleClass : this.createServerModules()) {
            this.registerModule(moduleClass);
        }
        this.serverComponents = new ServerComponentsLifecycleAdapter();
        this.life.add((Lifecycle)this.serverComponents);
        this.initialized = true;
    }

    @Override
    public void start() throws ServerStartupException {
        this.init();
        try {
            this.life.start();
        }
        catch (Throwable t) {
            this.life.shutdown();
            throw ServerStartupErrors.translateToServerStartupError(t);
        }
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected DatabaseActions createDatabaseActions() {
        return new DatabaseActions(new LeaseManager(Clocks.systemClock()), (Boolean)this.config.get(ServerSettings.script_sandboxing_enabled), (GraphDatabaseAPI)this.database.getGraph());
    }

    private TransactionFacade createTransactionalActions() {
        long timeoutMillis = this.getTransactionTimeoutMillis();
        Clock clock = Clocks.systemClock();
        this.transactionRegistry = new TransactionHandleRegistry(clock, timeoutMillis, this.logProvider);
        long runEvery = Math.round((double)timeoutMillis / 2.0);
        this.resolveDependency(JobScheduler.class).scheduleRecurring(JobScheduler.Groups.serverTransactionTimeout, () -> {
            long maxAge = clock.millis() - timeoutMillis;
            this.transactionRegistry.rollbackSuspendedTransactionsIdleSince(maxAge);
        }, runEvery, TimeUnit.MILLISECONDS);
        DependencyResolver dependencyResolver = this.database.getGraph().getDependencyResolver();
        return new TransactionFacade(new TransitionalPeriodTransactionMessContainer(this.database.getGraph()), (QueryExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class), (GraphDatabaseQueryService)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class), this.transactionRegistry, this.logProvider);
    }

    private long getTransactionTimeoutMillis() {
        long timeout = ((Duration)this.config.get(ServerSettings.transaction_idle_timeout)).toMillis();
        return Math.max(timeout, 2000L);
    }

    protected final void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules() {
        for (ServerModule module : this.serverModules) {
            module.start();
        }
    }

    private void stopModules() {
        new RunCarefully(Iterables.map(module -> module::stop, this.serverModules)).run();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    private void configureWebServer() {
        this.webServer.setAddress(this.httpListenAddress);
        this.webServer.setHttpsAddress(this.httpsListenAddress);
        this.webServer.setMaxThreads((Integer)this.config.get(ServerSettings.webserver_max_threads));
        this.webServer.setWadlEnabled((Boolean)this.config.get(ServerSettings.wadl_enabled));
        this.webServer.setDefaultInjectables(this.createDefaultInjectables());
        String sslPolicyName = (String)this.config.get(ServerSettings.ssl_policy);
        if (sslPolicyName != null) {
            SslPolicy sslPolicy = this.sslPolicyFactorySupplier.get().getPolicy(sslPolicyName);
            this.webServer.setSslPolicy(sslPolicy);
        }
    }

    private void startWebServer() throws Exception {
        try {
            this.setUpHttpLogging();
            this.webServer.start();
            InetSocketAddress localHttpAddress = this.webServer.getLocalHttpAddress();
            this.connectorPortRegister.register(this.httpConnector.key(), localHttpAddress);
            this.httpsConnector.ifPresent(connector -> this.connectorPortRegister.register(connector.key(), this.webServer.getLocalHttpsAddress()));
            this.checkHttpAdvertisedAddress(localHttpAddress);
            this.checkHttpsAdvertisedAddress();
            this.log.info("Remote interface available at %s", new Object[]{this.baseUri()});
        }
        catch (Exception e) {
            this.log.error("Failed to start Neo4j on %s: %s", new Object[]{this.getAddress(), e.getMessage()});
            throw e;
        }
    }

    private void checkHttpsAdvertisedAddress() {
        this.httpsAdvertisedAddress.ifPresent(address -> {
            if (address.getPort() == 0) {
                InetSocketAddress localHttpsAddress = this.webServer.getLocalHttpsAddress();
                this.httpsAdvertisedAddress = Optional.of(new AdvertisedSocketAddress(localHttpsAddress.getHostString(), localHttpsAddress.getPort()));
            }
        });
    }

    private void checkHttpAdvertisedAddress(InetSocketAddress localHttpAddress) {
        if (this.httpAdvertisedAddress.getPort() == 0) {
            this.httpAdvertisedAddress = new AdvertisedSocketAddress(localHttpAddress.getHostString(), localHttpAddress.getPort());
        }
    }

    private void setUpHttpLogging() throws IOException {
        if (!((Boolean)this.getConfig().get(ServerSettings.http_logging_enabled)).booleanValue()) {
            return;
        }
        AsyncRequestLog requestLog = new AsyncRequestLog((FileSystemAbstraction)this.dependencyResolver.resolveDependency(FileSystemAbstraction.class), ((LogTimeZone)this.config.get(GraphDatabaseSettings.db_timezone)).getZoneId(), ((File)this.config.get(ServerSettings.http_log_path)).toString(), (Long)this.config.get(ServerSettings.http_logging_rotation_size), (Integer)this.config.get(ServerSettings.http_logging_rotation_keep_number));
        this.webServer.setRequestLog(requestLog);
    }

    public ListenSocketAddress getAddress() {
        return this.httpListenAddress;
    }

    protected boolean httpsIsEnabled() {
        return this.httpsListenAddress.isPresent();
    }

    protected Pattern[] getUriWhitelist() {
        return DEFAULT_URI_WHITELIST;
    }

    @Override
    public void stop() {
        this.life.stop();
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public URI baseUri() {
        return this.uriBuilder.buildURI(this.httpAdvertisedAddress, false);
    }

    public Optional<URI> httpsUri() {
        return this.httpsAdvertisedAddress.map(address -> this.uriBuilder.buildURI((AdvertisedSocketAddress)address, true));
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public PluginManager getExtensionManager() {
        RESTApiModule module = this.getModule(RESTApiModule.class);
        if (module != null) {
            return module.getPlugins();
        }
        return null;
    }

    protected Collection<InjectableProvider<?>> createDefaultInjectables() {
        ArrayList singletons = new ArrayList();
        Database database = this.getDatabase();
        singletons.add(new DatabaseProvider(database));
        singletons.add(new DatabaseActions.Provider(this.databaseActions));
        singletons.add(new GraphDatabaseServiceProvider(database));
        singletons.add(new NeoServerProvider(this));
        singletons.add(InjectableProvider.providerForSingleton(new ConfigAdapter(this.getConfig()), Configuration.class));
        singletons.add(InjectableProvider.providerForSingleton(this.getConfig(), Config.class));
        singletons.add(new WebServerProvider(this.getWebServer()));
        PluginInvocatorProvider pluginInvocatorProvider = new PluginInvocatorProvider(this);
        singletons.add(pluginInvocatorProvider);
        RepresentationFormatRepository repository = new RepresentationFormatRepository(this);
        singletons.add(new InputFormatProvider(repository));
        singletons.add(new OutputFormatProvider(repository));
        singletons.add(new CypherExecutorProvider(this.cypherExecutor));
        singletons.add(InjectableProvider.providerForSingleton(this.transactionFacade, TransactionFacade.class));
        singletons.add(InjectableProvider.providerFromSupplier(this.authManagerSupplier, AuthManager.class));
        singletons.add(InjectableProvider.providerFromSupplier(this.userManagerSupplier, UserManagerSupplier.class));
        singletons.add(new TransactionFilter(database));
        singletons.add(new LoggingProvider(this.logProvider));
        singletons.add(InjectableProvider.providerForSingleton(this.logProvider.getLog(NeoServer.class), Log.class));
        singletons.add(InjectableProvider.providerForSingleton(this.resolveDependency(UsageData.class), UsageData.class));
        return singletons;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }

    protected <T> T resolveDependency(Class<T> type) {
        return (T)this.dependencyResolver.resolveDependency(type);
    }

    private class ServerComponentsLifecycleAdapter
    extends LifecycleAdapter {
        private ServerComponentsLifecycleAdapter() {
        }

        public void start() throws Throwable {
            DiagnosticsManager diagnosticsManager = AbstractNeoServer.this.resolveDependency(DiagnosticsManager.class);
            Log diagnosticsLog = diagnosticsManager.getTargetLog();
            diagnosticsLog.info("--- SERVER STARTED START ---");
            AbstractNeoServer.this.connectorPortRegister = (ConnectorPortRegister)AbstractNeoServer.this.dependencyResolver.resolveDependency(ConnectorPortRegister.class);
            AbstractNeoServer.this.databaseActions = AbstractNeoServer.this.createDatabaseActions();
            AbstractNeoServer.this.transactionFacade = AbstractNeoServer.this.createTransactionalActions();
            AbstractNeoServer.this.cypherExecutor = new CypherExecutor(AbstractNeoServer.this.database, AbstractNeoServer.this.logProvider);
            AbstractNeoServer.this.configureWebServer();
            AbstractNeoServer.this.cypherExecutor.start();
            AbstractNeoServer.this.startModules();
            AbstractNeoServer.this.startWebServer();
            diagnosticsLog.info("--- SERVER STARTED END ---");
        }

        public void stop() {
            AbstractNeoServer.this.stopWebServer();
            AbstractNeoServer.this.stopModules();
        }
    }
}

