/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.InvalidArgumentsException;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.RepresentationFormat;

public class NullFormat
extends RepresentationFormat {
    private final Collection<MediaType> supported;
    private final MediaType[] requested;

    public NullFormat(Collection<MediaType> supported, MediaType ... requested) {
        super(null);
        this.supported = supported;
        this.requested = requested;
    }

    public Object readValue(String input) {
        if (this.empty(input)) {
            return null;
        }
        throw new MediaTypeNotSupportedException(Response.Status.UNSUPPORTED_MEDIA_TYPE, this.supported, this.requested);
    }

    public URI readUri(String input) {
        if (this.empty(input)) {
            return null;
        }
        throw new MediaTypeNotSupportedException(Response.Status.UNSUPPORTED_MEDIA_TYPE, this.supported, this.requested);
    }

    public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
        if (this.empty(input)) {
            if (requiredKeys.length != 0) {
                String missingKeys = Arrays.toString(requiredKeys);
                throw new InvalidArgumentsException("Missing required keys: " + missingKeys);
            }
            return Collections.emptyMap();
        }
        throw new MediaTypeNotSupportedException(Response.Status.UNSUPPORTED_MEDIA_TYPE, this.supported, this.requested);
    }

    public List<Object> readList(String input) {
        if (this.empty(input)) {
            return Collections.emptyList();
        }
        throw new MediaTypeNotSupportedException(Response.Status.UNSUPPORTED_MEDIA_TYPE, this.supported, this.requested);
    }

    private boolean empty(String input) {
        return input == null || "".equals(input.trim());
    }

    protected String serializeValue(String type, Object value) {
        throw new MediaTypeNotSupportedException(Response.Status.NOT_ACCEPTABLE, this.supported, this.requested);
    }

    protected ListWriter serializeList(String type) {
        throw new MediaTypeNotSupportedException(Response.Status.NOT_ACCEPTABLE, this.supported, this.requested);
    }

    protected MappingWriter serializeMapping(String type) {
        throw new MediaTypeNotSupportedException(Response.Status.NOT_ACCEPTABLE, this.supported, this.requested);
    }

    protected String complete(ListWriter serializer) {
        throw new MediaTypeNotSupportedException(Response.Status.NOT_ACCEPTABLE, this.supported, this.requested);
    }

    protected String complete(MappingWriter serializer) {
        throw new MediaTypeNotSupportedException(Response.Status.NOT_ACCEPTABLE, this.supported, this.requested);
    }
}

