/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.security.SecurityFilter;
import org.neo4j.server.rest.security.SecurityRule;
import org.neo4j.server.web.WebServer;

public class SecurityRulesModule
implements ServerModule {
    private final WebServer webServer;
    private final Config config;
    private final Log log;
    private SecurityFilter mountedFilter;

    public SecurityRulesModule(WebServer webServer, Config config, LogProvider logProvider) {
        this.webServer = webServer;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void start() {
        Iterable<SecurityRule> securityRules = this.getSecurityRules();
        if (Iterables.count(securityRules) > 0L) {
            this.mountedFilter = new SecurityFilter(securityRules);
            this.webServer.addFilter(this.mountedFilter, "/*");
            for (SecurityRule rule : securityRules) {
                this.log.info("Security rule [%s] installed on server", new Object[]{rule.getClass().getCanonicalName()});
            }
        }
    }

    @Override
    public void stop() {
        if (this.mountedFilter != null) {
            this.mountedFilter.destroy();
        }
    }

    private Iterable<SecurityRule> getSecurityRules() {
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        for (String classname : (List)this.config.get(ServerSettings.security_rules)) {
            try {
                rules.add((SecurityRule)Class.forName(classname).newInstance());
            }
            catch (Exception e) {
                this.log.error("Could not load server security rule [%s], exception details: ", new Object[]{classname, e.getMessage()});
                e.printStackTrace();
            }
        }
        return rules;
    }
}

