/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.formats.ListWrappingWriter;

public class MapWrappingWriter
extends MappingWriter {
    final Map<String, Object> data;
    final boolean interactive;

    public MapWrappingWriter(Map<String, Object> data) {
        this(data, false);
    }

    public MapWrappingWriter(Map<String, Object> data, boolean interactive) {
        this.data = data;
        this.interactive = interactive;
    }

    protected final boolean isInteractive() {
        return this.interactive;
    }

    protected ListWriter newList(String type, String key) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.data.put(key, list);
        return new ListWrappingWriter(list, this.interactive);
    }

    protected MappingWriter newMapping(String type, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.data.put(key, map);
        return new MapWrappingWriter(map, this.interactive);
    }

    protected void writeValue(String type, String key, Object value) {
        this.data.put(key, value);
    }

    protected void done() {
    }
}

