/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.neo4j.server.rest.web.InternalJettyServletResponse;
import org.neo4j.string.UTF8;

public class InternalJettyServletRequest
extends Request {
    private static final HttpChannelState DUMMY_HTTP_CHANNEL_STATE = new HttpChannelState(null){

        public boolean isAsync() {
            return false;
        }
    };
    private final Map<String, Object> headers;
    private final Cookie[] cookies;
    private final Input input;
    private final BufferedReader inputReader;
    private String contentType;
    private final String method;
    private final InternalJettyServletResponse response;
    private final RequestData requestData;

    public InternalJettyServletRequest(String method, String uri, String body, InternalJettyServletResponse res, RequestData requestData) throws UnsupportedEncodingException {
        this(method, new HttpURI(uri), body, new Cookie[0], "application/json", StandardCharsets.UTF_8.name(), res, requestData);
    }

    public InternalJettyServletRequest(String method, HttpURI uri, String body, Cookie[] cookies, String contentType, String encoding, InternalJettyServletResponse res, RequestData requestData) throws UnsupportedEncodingException {
        super(null, null);
        this.input = new Input(body);
        this.inputReader = new BufferedReader(new StringReader(body));
        this.contentType = contentType;
        this.cookies = cookies;
        this.method = method;
        this.response = res;
        this.requestData = requestData;
        this.headers = new HashMap<String, Object>();
        this.setUri(uri);
        this.setCharacterEncoding(encoding);
        this.setRequestURI(null);
        this.setQueryString(null);
        this.setScheme(uri.getScheme());
        this.setDispatcherType(DispatcherType.REQUEST);
    }

    public int getContentLength() {
        return this.input.length();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public long getContentRead() {
        return this.input.contentRead();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.input;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() throws IOException {
        return this.inputReader;
    }

    public String getRemoteAddr() {
        return this.requestData.remoteAddress;
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException("Remote host-name lookup might prove expensive, this should be explicitly considered.");
    }

    public boolean isSecure() {
        return this.requestData.isSecure;
    }

    public int getRemotePort() {
        return this.requestData.remotePort;
    }

    public String getLocalName() {
        return this.requestData.localName;
    }

    public String getLocalAddr() {
        return this.requestData.localAddress;
    }

    public int getLocalPort() {
        return this.requestData.localPort;
    }

    public String getAuthType() {
        return this.requestData.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public long getDateHeader(String name) {
        if (this.headers.containsKey(name)) {
            return (Long)this.headers.get(name);
        }
        return -1L;
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name)) {
            Object value = this.headers.get(name);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Collection) {
                return ((Collection)value).iterator().next().toString();
            }
            return value.toString();
        }
        return null;
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.headers.containsKey(name)) {
            Object value = this.headers.get(name);
            if (value instanceof Collection) {
                return Collections.enumeration((Collection)value);
            }
            return Collections.enumeration(Collections.singleton((String)value));
        }
        return null;
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        if (this.headers.containsKey(name)) {
            return (Integer)this.headers.get(name);
        }
        return -1;
    }

    public String getMethod() {
        return this.method;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("%s %s %s\n%s", this.getMethod(), this.getUri(), this.getProtocol(), this.getHttpFields());
    }

    public HttpChannelState getHttpChannelState() {
        return DUMMY_HTTP_CHANNEL_STATE;
    }

    public static class RequestData {
        public final String remoteAddress;
        public final boolean isSecure;
        public final int remotePort;
        public final String localName;
        public final String localAddress;
        public final int localPort;
        public final String authType;

        public RequestData(String remoteAddress, boolean isSecure, int remotePort, String localName, String localAddress, int localPort, String authType) {
            this.remoteAddress = remoteAddress;
            this.isSecure = isSecure;
            this.remotePort = remotePort;
            this.localName = localName;
            this.localAddress = localAddress;
            this.localPort = localPort;
            this.authType = authType;
        }

        public static RequestData from(HttpServletRequest req) {
            return new RequestData(req.getRemoteAddr(), req.isSecure(), req.getRemotePort(), req.getLocalName(), req.getLocalAddr(), req.getLocalPort(), req.getAuthType() == null ? "" : req.getAuthType());
        }
    }

    private class Input
    extends ServletInputStream {
        private final byte[] bytes;
        private int position = 0;
        private ReadListener readListener;

        public Input(String data) {
            this.bytes = UTF8.encode((String)data);
        }

        public int read() throws IOException {
            if (this.bytes.length > this.position) {
                return this.bytes[this.position++];
            }
            if (this.readListener != null) {
                this.readListener.onAllDataRead();
            }
            return -1;
        }

        public int length() {
            return this.bytes.length;
        }

        public long contentRead() {
            return this.position;
        }

        public boolean isFinished() {
            return this.bytes.length == this.position;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            this.readListener = readListener;
            try {
                readListener.onDataAvailable();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

