/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.configuration.AbstractConfiguration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.AnnotatedFieldHarvester;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;

public class ConfigAdapter
extends AbstractConfiguration {
    private final Config config;

    public ConfigAdapter(Config config) {
        this.config = config;
    }

    public boolean isEmpty() {
        return this.config == null;
    }

    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    public Object getProperty(String key) {
        return this.config.get(this.getSettingForKey(key));
    }

    public Iterator<String> getKeys() {
        HashSet propertyKeys = new HashSet(this.config.getParams().keySet());
        for (String registeredSettingName : this.getRegisteredSettings().keySet()) {
            if (!this.containsKey(registeredSettingName)) continue;
            propertyKeys.add(registeredSettingName);
        }
        return propertyKeys.iterator();
    }

    protected void addPropertyDirect(String key, Object value) {
        this.config.augment(MapUtil.stringMap((String[])new String[]{key, value.toString()}));
    }

    private Setting<?> getSettingForKey(String key) {
        Setting<?> setting = this.getRegisteredSettings().get(key);
        if (setting != null) {
            return setting;
        }
        return Settings.setting((String)key, (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
    }

    private Map<String, Setting<?>> getRegisteredSettings() {
        Iterable settingsClasses = this.config.getSettingsClasses();
        AnnotatedFieldHarvester fieldHarvester = new AnnotatedFieldHarvester();
        HashMap settings = new HashMap();
        for (Class clazz : settingsClasses) {
            for (Pair field : fieldHarvester.findStatic(clazz, Setting.class)) {
                settings.put(((Setting)field.other()).name(), (Setting<?>)field.other());
            }
        }
        return settings;
    }
}

