/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.modules.ExtensionInitializer;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.web.WebServer;

public class ThirdPartyJAXRSModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;
    private final ExtensionInitializer extensionInitializer;
    private List<ThirdPartyJaxRsPackage> packages;
    private final Log log;

    public ThirdPartyJAXRSModule(WebServer webServer, Config config, LogProvider logProvider, NeoServer neoServer) {
        this.webServer = webServer;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
        this.extensionInitializer = new ExtensionInitializer(neoServer);
    }

    @Override
    public void start() {
        this.packages = (List)this.config.get(ServerSettings.third_party_packages);
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            List<String> packageNames = this.packagesFor(tpp);
            Collection<Injectable<?>> injectables = this.extensionInitializer.initializePackages(packageNames);
            this.webServer.addJAXRSPackages(packageNames, tpp.getMountPoint(), injectables);
            this.log.info("Mounted unmanaged extension [%s] at [%s]", new Object[]{tpp.getPackageName(), tpp.getMountPoint()});
        }
    }

    private List<String> packagesFor(ThirdPartyJaxRsPackage tpp) {
        return Arrays.asList(tpp.getPackageName());
    }

    @Override
    public void stop() {
        if (this.packages == null) {
            return;
        }
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            this.webServer.removeJAXRSPackages(this.packagesFor(tpp), tpp.getMountPoint());
        }
        this.extensionInitializer.stop();
    }
}

