/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;

public class DiscoveryRepresentation
extends MappingRepresentation {
    private static final String DATA_URI_KEY = "data";
    private static final String MANAGEMENT_URI_KEY = "management";
    private static final String BOLT_URI_KEY = "bolt";
    private static final String DISCOVERY_REPRESENTATION_TYPE = "discovery";
    private final String managementUri;
    private final String dataUri;
    private final String boltAddress;

    public DiscoveryRepresentation(String managementUri, String dataUri, String boltAddress) {
        super(DISCOVERY_REPRESENTATION_TYPE);
        this.managementUri = managementUri;
        this.dataUri = dataUri;
        this.boltAddress = boltAddress;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putRelativeUri(MANAGEMENT_URI_KEY, this.managementUri);
        serializer.putRelativeUri(DATA_URI_KEY, this.dataUri);
        if (this.boltAddress != null) {
            serializer.putAbsoluteUri(BOLT_URI_KEY, "bolt://" + this.boltAddress);
        }
    }
}

