/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.neo4j.bolt.security.ssl.KeyStoreInformation;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.web.HttpConnectorFactory;
import org.neo4j.server.web.JettyThreadCalculator;

public class SslSocketConnectorFactory
extends HttpConnectorFactory {
    public SslSocketConnectorFactory(Config configuration) {
        super(configuration);
    }

    @Override
    protected HttpConfiguration createHttpConfig() {
        HttpConfiguration httpConfig = super.createHttpConfig();
        httpConfig.addCustomizer((connector, channelConfig, request) -> request.setScheme(HttpScheme.HTTPS.asString()));
        return httpConfig;
    }

    public ServerConnector createConnector(Server server, KeyStoreInformation config, ListenSocketAddress address, JettyThreadCalculator jettyThreadCalculator) {
        SslConnectionFactory sslConnectionFactory = this.createSslConnectionFactory(config);
        return super.createConnector(server, address, jettyThreadCalculator, new ConnectionFactory[]{sslConnectionFactory, this.createHttpConnectionFactory()});
    }

    private SslConnectionFactory createSslConnectionFactory(KeyStoreInformation ksInfo) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStore(ksInfo.getKeyStore());
        sslContextFactory.setKeyStorePassword(String.valueOf(ksInfo.getKeyStorePassword()));
        sslContextFactory.setKeyManagerPassword(String.valueOf(ksInfo.getKeyPassword()));
        return new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
    }
}

