/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.server.rest.dbms.AuthorizationFilter;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;

public class AuthorizationDisabledFilter
extends AuthorizationFilter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.validateRequestType(servletRequest);
        this.validateResponseType(servletResponse);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            filterChain.doFilter((ServletRequest)new AuthorizedRequestWrapper("BASIC", "neo4j", request, this.getAuthDisabledAccessMode()), servletResponse);
        }
        catch (AuthorizationViolationException e) {
            AuthorizationDisabledFilter.unauthorizedAccess(e.getMessage()).accept((Object)response);
        }
    }

    protected AccessMode getAuthDisabledAccessMode() {
        return AuthSubject.AUTH_DISABLED;
    }
}

