/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/")
public class DiscoveryService {
    private final Config configuration;
    private final OutputFormat outputFormat;

    public DiscoveryService(@Context Config configuration, @Context OutputFormat outputFormat) {
        this.configuration = configuration;
        this.outputFormat = outputFormat;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDiscoveryDocument() throws URISyntaxException {
        String managementUri = ((URI)this.configuration.get(ServerSettings.management_api_path)).getPath() + "/";
        String dataUri = ((URI)this.configuration.get(ServerSettings.rest_api_path)).getPath() + "/";
        String boltAddress = ((HostnamePort)this.configuration.get(GraphDatabaseSettings.bolt_advertised_address)).toString();
        return this.outputFormat.ok((Representation)new DiscoveryRepresentation(managementUri, dataUri, boltAddress));
    }

    @GET
    @Produces(value={"*/*"})
    public Response redirectToBrowser() {
        return this.outputFormat.seeOther((URI)this.configuration.get(ServerSettings.browser_path));
    }
}

