/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.dbms.AuthorizationDisabledFilter;
import org.neo4j.server.rest.dbms.AuthorizationEnabledFilter;
import org.neo4j.server.rest.dbms.AuthorizationFilter;
import org.neo4j.server.web.WebServer;

public class AuthorizationModule
implements ServerModule {
    private final WebServer webServer;
    private final Config config;
    private final Supplier<AuthManager> authManagerSupplier;
    private final LogProvider logProvider;
    private final Pattern[] uriWhitelist;

    public AuthorizationModule(WebServer webServer, Supplier<AuthManager> authManager, LogProvider logProvider, Config config, Pattern[] uriWhitelist) {
        this.webServer = webServer;
        this.config = config;
        this.authManagerSupplier = authManager;
        this.logProvider = logProvider;
        this.uriWhitelist = uriWhitelist;
    }

    @Override
    public void start() {
        AuthorizationFilter authorizationFilter = (Boolean)this.config.get(GraphDatabaseSettings.auth_enabled) != false ? new AuthorizationEnabledFilter(this.authManagerSupplier, this.logProvider, this.uriWhitelist) : new AuthorizationDisabledFilter();
        this.webServer.addFilter(authorizationFilter, "/*");
    }

    @Override
    public void stop() {
    }
}

