/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerCommandLineArgs;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.logging.JULBridge;
import org.neo4j.server.logging.JettyLogBridge;

public abstract class ServerBootstrapper
implements Bootstrapper {
    public static final int OK = 0;
    public static final int WEB_SERVER_STARTUP_ERROR_CODE = 1;
    public static final int GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    private NeoServer server;
    private Thread shutdownHook;
    private GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies();
    private Log log;
    private String serverAddress = "unknown address";

    public static int start(Bootstrapper boot, String ... argv) {
        ServerCommandLineArgs args = ServerCommandLineArgs.parse(argv);
        if (args.homeDir() == null) {
            throw new ServerStartupException("Argument --home-dir is required and was not provided.");
        }
        return boot.start(args.homeDir(), args.configFile(), args.configOverrides());
    }

    @Override
    @SafeVarargs
    public final int start(File homeDir, Optional<File> configFile, Pair<String, String> ... configOverrides) {
        LogProvider userLogProvider = ServerBootstrapper.setupLogging();
        this.dependencies = this.dependencies.userLogProvider(userLogProvider);
        this.log = userLogProvider.getLog(this.getClass());
        try {
            Config config = this.createConfig(this.log, homeDir, configFile, configOverrides);
            this.serverAddress = ServerSettings.httpConnector(config, ServerSettings.HttpConnector.Encryption.NONE).map(connector -> connector.address.toString()).orElse(this.serverAddress);
            this.checkCompatibility();
            this.server = this.createNeoServer(config, this.dependencies, userLogProvider);
            this.server.start();
            this.addShutdownHook();
            return 0;
        }
        catch (ServerStartupException e) {
            e.describeTo(this.log);
            return 1;
        }
        catch (TransactionFailureException tfe) {
            String locationMsg = this.server == null ? "" : " Another process may be using database location " + this.server.getDatabase().getLocation();
            this.log.error(String.format("Failed to start Neo4j on %s.", this.serverAddress) + locationMsg, (Throwable)tfe);
            return 2;
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to start Neo4j on %s", this.serverAddress), (Throwable)e);
            return 1;
        }
    }

    @Override
    public int stop() {
        String location = "unknown location";
        try {
            if (this.server != null) {
                this.server.stop();
            }
            this.removeShutdownHook();
            return 0;
        }
        catch (Exception e) {
            this.log.error("Failed to cleanly shutdown Neo Server on port [%s], database [%s]. Reason [%s] ", new Object[]{this.serverAddress, location, e.getMessage(), e});
            return 1;
        }
    }

    public boolean isRunning() {
        return this.server != null && this.server.getDatabase() != null && this.server.getDatabase().isRunning();
    }

    public NeoServer getServer() {
        return this.server;
    }

    protected abstract NeoServer createNeoServer(Config var1, GraphDatabaseDependencies var2, LogProvider var3);

    protected abstract Iterable<Class<?>> settingsClasses(Map<String, String> var1);

    private static LogProvider setupLogging() {
        FormattedLogProvider userLogProvider = FormattedLogProvider.withoutRenderingContext().toOutputStream((OutputStream)System.out);
        JULBridge.resetJUL();
        Logger.getLogger("").setLevel(Level.WARNING);
        JULBridge.forwardTo((LogProvider)userLogProvider);
        JettyLogBridge.setLogProvider((LogProvider)userLogProvider);
        return userLogProvider;
    }

    private Config createConfig(Log log, File homeDir, Optional<File> file, Pair<String, String>[] configOverrides) throws IOException {
        return new ConfigLoader(this::settingsClasses).loadConfig(Optional.of(homeDir), file, log, configOverrides);
    }

    private void addShutdownHook() {
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                ServerBootstrapper.this.log.info("Neo4j Server shutdown initiated by request");
                if (ServerBootstrapper.this.server != null) {
                    ServerBootstrapper.this.server.stop();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null && !Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
            this.log.warn("Unable to remove shutdown hook");
        }
    }

    private void checkCompatibility() {
        new JvmChecker(this.log, new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
    }
}

