/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.core.HttpContext;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.bouncycastle.operator.OperatorCreationException;
import org.neo4j.bolt.security.ssl.Certificates;
import org.neo4j.bolt.security.ssl.KeyStoreFactory;
import org.neo4j.bolt.security.ssl.KeyStoreInformation;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.RunCarefully;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.LoggingProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerProvider;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.CypherExecutorProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseProvider;
import org.neo4j.server.database.GraphDatabaseServiceProvider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.exception.ServerStartupErrors;
import org.neo4j.server.guard.GuardingRequestFilter;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.ConfigAdapter;
import org.neo4j.server.plugins.PluginInvocatorProvider;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionFilter;
import org.neo4j.server.rest.transactional.TransactionHandleRegistry;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.web.AsyncRequestLog;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.web.WebServerProvider;
import org.neo4j.udc.UsageData;

public abstract class AbstractNeoServer
implements NeoServer {
    private static final long MINIMUM_TIMEOUT = 1000L;
    private static final long ROUNDING_SECOND = 1000L;
    private static final Pattern[] DEFAULT_URI_WHITELIST = new Pattern[]{Pattern.compile("/browser.*"), Pattern.compile("/")};
    private final Database.Factory dbFactory;
    private final GraphDatabaseFacadeFactory.Dependencies dependencies;
    protected final LogProvider logProvider;
    protected final Log log;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private final Config config;
    private final LifeSupport life = new LifeSupport();
    private final HostnamePort httpAddress;
    private final Optional<HostnamePort> httpsAddress;
    protected Database database;
    protected CypherExecutor cypherExecutor;
    protected WebServer webServer;
    protected Supplier<AuthManager> authManagerSupplier;
    protected Optional<KeyStoreInformation> keyStoreInfo;
    private DatabaseActions databaseActions;
    private TransactionFacade transactionFacade;
    private TransactionHandleRegistry transactionRegistry;
    private boolean initialized = false;
    private final Dependencies dependencyResolver = new Dependencies((Supplier)new Supplier<DependencyResolver>(){

        @Override
        public DependencyResolver get() {
            Database db = (Database)AbstractNeoServer.this.dependencyResolver.resolveDependency(Database.class);
            return db.getGraph().getDependencyResolver();
        }
    });

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract WebServer createWebServer();

    public AbstractNeoServer(Config config, Database.Factory dbFactory, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        this.config = config;
        this.dbFactory = dbFactory;
        this.dependencies = dependencies;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.httpAddress = (HostnamePort)ServerSettings.httpConnector((Config)config, (ServerSettings.HttpConnector.Encryption)ServerSettings.HttpConnector.Encryption.NONE).orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$1(), ()Ljava/lang/IllegalArgumentException;)()).address.from((Configuration)config);
        this.httpsAddress = ServerSettings.httpConnector(config, ServerSettings.HttpConnector.Encryption.TLS).map(connector -> (HostnamePort)connector.address.from((Configuration)config));
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.database = (Database)this.life.add((Lifecycle)this.dependencyResolver.satisfyDependency((Object)this.dbFactory.newDatabase(this.config, this.dependencies)));
        this.authManagerSupplier = this.dependencyResolver.provideDependency(AuthManager.class);
        this.webServer = this.createWebServer();
        this.keyStoreInfo = this.createKeyStore();
        for (ServerModule moduleClass : this.createServerModules()) {
            this.registerModule(moduleClass);
        }
        this.initialized = true;
    }

    @Override
    public void start() throws ServerStartupException {
        this.init();
        try {
            this.life.start();
            DiagnosticsManager diagnosticsManager = this.resolveDependency(DiagnosticsManager.class);
            Log diagnosticsLog = diagnosticsManager.getTargetLog();
            diagnosticsLog.info("--- SERVER STARTED START ---");
            this.databaseActions = this.createDatabaseActions();
            this.transactionFacade = this.createTransactionalActions();
            this.cypherExecutor = new CypherExecutor(this.database);
            this.configureWebServer();
            this.cypherExecutor.start();
            this.startModules();
            this.startWebServer();
            diagnosticsLog.info("--- SERVER STARTED END ---");
        }
        catch (Throwable t) {
            this.life.shutdown();
            throw ServerStartupErrors.translateToServerStartupError(t);
        }
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected DatabaseActions createDatabaseActions() {
        return new DatabaseActions(new LeaseManager(Clock.SYSTEM_CLOCK), (Boolean)this.config.get(ServerSettings.script_sandboxing_enabled), (GraphDatabaseAPI)this.database.getGraph());
    }

    private TransactionFacade createTransactionalActions() {
        long timeoutMillis = this.getTransactionTimeoutMillis();
        Clock clock = Clock.SYSTEM_CLOCK;
        this.transactionRegistry = new TransactionHandleRegistry(clock, timeoutMillis, this.logProvider);
        long runEvery = Math.round((double)timeoutMillis / 2.0);
        this.resolveDependency(JobScheduler.class).scheduleRecurring(JobScheduler.Groups.serverTransactionTimeout, () -> {
            long maxAge = clock.currentTimeMillis() - timeoutMillis;
            this.transactionRegistry.rollbackSuspendedTransactionsIdleSince(maxAge);
        }, runEvery, TimeUnit.MILLISECONDS);
        return new TransactionFacade(new TransitionalPeriodTransactionMessContainer(this.database.getGraph()), (QueryExecutionEngine)this.database.getGraph().getDependencyResolver().resolveDependency(QueryExecutionEngine.class), this.transactionRegistry, this.logProvider);
    }

    private long getTransactionTimeoutMillis() {
        long timeout = (Long)this.config.get(ServerSettings.transaction_timeout);
        return Math.max(timeout, 2000L);
    }

    protected final void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules() {
        for (ServerModule module : this.serverModules) {
            module.start();
        }
    }

    private void stopModules() {
        new RunCarefully(Iterables.map(module -> module::stop, this.serverModules)).run();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    private void configureWebServer() throws Exception {
        this.webServer.setAddress(this.httpAddress);
        this.webServer.setHttpsAddress(this.httpsAddress);
        this.webServer.setMaxThreads((Integer)this.config.get(ServerSettings.webserver_max_threads));
        this.webServer.setWadlEnabled((Boolean)this.config.get(ServerSettings.wadl_enabled));
        this.webServer.setDefaultInjectables(this.createDefaultInjectables());
        if (this.keyStoreInfo.isPresent()) {
            this.webServer.setHttpsCertificateInformation(this.keyStoreInfo.get());
        }
    }

    private void startWebServer() throws Exception {
        try {
            this.setUpHttpLogging();
            this.setUpTimeoutFilter();
            this.webServer.start();
            this.log.info("Remote interface available at %s", new Object[]{this.baseUri()});
        }
        catch (Exception e) {
            this.log.error("Failed to start Neo4j on %s: %s", new Object[]{this.getAddress(), e.getMessage()});
            throw e;
        }
    }

    private void setUpHttpLogging() throws IOException {
        if (!((Boolean)this.getConfig().get(ServerSettings.http_logging_enabled)).booleanValue()) {
            return;
        }
        AsyncRequestLog requestLog = new AsyncRequestLog((FileSystemAbstraction)new DefaultFileSystemAbstraction(), new File((File)this.config.get(GraphDatabaseSettings.logs_directory), "http.log").toString(), (Long)this.config.get(ServerSettings.http_logging_rotation_size), (Integer)this.config.get(ServerSettings.http_logging_rotation_keep_number));
        this.webServer.setRequestLog(requestLog);
    }

    private void setUpTimeoutFilter() {
        if (this.getConfig().get(ServerSettings.webserver_limit_execution_time) == null) {
            return;
        }
        Guard guard = this.resolveDependency(Guard.class);
        if (guard == null) {
            throw new RuntimeException(String.format("Inconsistent configuration. In order to use %s, you must set %s.", ServerSettings.webserver_limit_execution_time.name(), GraphDatabaseSettings.execution_guard_enabled.name()));
        }
        GuardingRequestFilter filter = new GuardingRequestFilter(guard, (Long)this.getConfig().get(ServerSettings.webserver_limit_execution_time));
        this.webServer.addFilter(filter, "/*");
    }

    public HostnamePort getAddress() {
        return this.httpAddress;
    }

    protected boolean httpsIsEnabled() {
        return this.httpsAddress.isPresent();
    }

    protected Pattern[] getUriWhitelist() {
        return DEFAULT_URI_WHITELIST;
    }

    protected Optional<KeyStoreInformation> createKeyStore() {
        if (this.httpsIsEnabled()) {
            File privateKeyPath = ((File)this.config.get(ServerSettings.tls_key_file)).getAbsoluteFile();
            File certificatePath = ((File)this.config.get(ServerSettings.tls_certificate_file)).getAbsoluteFile();
            try {
                if (!certificatePath.exists() && !privateKeyPath.exists()) {
                    this.log.info("No SSL certificate found, generating a self-signed certificate..");
                    Certificates certFactory = new Certificates();
                    certFactory.createSelfSignedCertificate(certificatePath, privateKeyPath, this.httpAddress.getHost());
                }
                if (!certificatePath.exists()) {
                    throw new ServerStartupException(String.format("TLS private key found, but missing certificate at '%s'. Cannot start server without certificate.", certificatePath));
                }
                if (!privateKeyPath.exists()) {
                    throw new ServerStartupException(String.format("TLS certificate found, but missing key at '%s'. Cannot start server without key.", privateKeyPath));
                }
                return Optional.of(new KeyStoreFactory().createKeyStore(privateKeyPath, certificatePath));
            }
            catch (GeneralSecurityException e) {
                throw new ServerStartupException("TLS certificate error occurred, unable to start server: " + e.getMessage(), e);
            }
            catch (IOException | OperatorCreationException e) {
                throw new ServerStartupException("IO problem while loading or creating TLS certificates: " + e.getMessage(), e);
            }
        }
        return Optional.empty();
    }

    @Override
    public void stop() {
        Runnable[] runnableArray = new Runnable[3];
        runnableArray[0] = this::stopWebServer;
        runnableArray[1] = this::stopModules;
        runnableArray[2] = () -> ((LifeSupport)this.life).stop();
        new RunCarefully(runnableArray).run();
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public URI baseUri() {
        return this.uriBuilder.buildURI(this.httpAddress, false);
    }

    public Optional<URI> httpsUri() {
        return this.httpsAddress.map(address -> this.uriBuilder.buildURI((HostnamePort)address, true));
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public PluginManager getExtensionManager() {
        if (this.hasModule(RESTApiModule.class)) {
            return this.getModule(RESTApiModule.class).getPlugins();
        }
        return null;
    }

    protected Collection<InjectableProvider<?>> createDefaultInjectables() {
        ArrayList singletons = new ArrayList();
        Database database = this.getDatabase();
        singletons.add(new DatabaseProvider(database));
        singletons.add(new DatabaseActions.Provider(this.databaseActions));
        singletons.add(new GraphDatabaseServiceProvider(database));
        singletons.add(new NeoServerProvider(this));
        singletons.add(InjectableProvider.providerForSingleton(new ConfigAdapter(this.getConfig()), org.apache.commons.configuration.Configuration.class));
        singletons.add(InjectableProvider.providerForSingleton(this.getConfig(), Config.class));
        singletons.add(new WebServerProvider(this.getWebServer()));
        PluginInvocatorProvider pluginInvocatorProvider = new PluginInvocatorProvider(this);
        singletons.add(pluginInvocatorProvider);
        RepresentationFormatRepository repository = new RepresentationFormatRepository(this);
        singletons.add(new InputFormatProvider(repository));
        singletons.add(new OutputFormatProvider(repository));
        singletons.add(new CypherExecutorProvider(this.cypherExecutor));
        singletons.add(InjectableProvider.providerForSingleton(this.transactionFacade, TransactionFacade.class));
        singletons.add(new AuthManagerProvider(this.authManagerSupplier));
        singletons.add(new TransactionFilter(database));
        singletons.add(new LoggingProvider(this.logProvider));
        singletons.add(InjectableProvider.providerForSingleton(this.logProvider.getLog(NeoServer.class), Log.class));
        singletons.add(InjectableProvider.providerForSingleton(this.resolveDependency(UsageData.class), UsageData.class));
        return singletons;
    }

    private boolean hasModule(Class<? extends ServerModule> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }

    protected <T> T resolveDependency(Class<T> type) {
        return (T)this.dependencyResolver.resolveDependency(type);
    }

    private static /* synthetic */ IllegalArgumentException lambda$new$1() {
        return new IllegalArgumentException("An HTTP connector must be configured to run the server");
    }

    private static class AuthManagerProvider
    extends InjectableProvider<AuthManager> {
        private final Supplier<AuthManager> authManagerSupplier;

        private AuthManagerProvider(Supplier<AuthManager> authManagerSupplier) {
            super(AuthManager.class);
            this.authManagerSupplier = authManagerSupplier;
        }

        public AuthManager getValue(HttpContext httpContext) {
            return this.authManagerSupplier.get();
        }
    }
}

