/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.error;

import java.io.File;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.neo4j.kernel.api.exceptions.Status;

public class ErrorDocumentationGenerator {
    public static void main(String[] args) throws Exception {
        File baseDir = ErrorDocumentationGenerator.getBaseDirectory(args);
        ErrorDocumentationGenerator generator = new ErrorDocumentationGenerator();
        try {
            ErrorDocumentationGenerator.generateDocumentation(generator.generateClassificationDocs(), new File(baseDir, "status-code-classifications.asccidoc"), "status code classification");
            ErrorDocumentationGenerator.generateDocumentation(generator.generateStatusCodeDocs(), new File(baseDir, "status-code-codes.asccidoc"), "status code statuses");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.flush();
            System.exit(1);
        }
    }

    private static File getBaseDirectory(String[] args) {
        File baseDir = null;
        if (args.length == 1) {
            baseDir = new File(args[0]);
        } else {
            System.out.println("Usage: ErrorDocumentationGenerator [output folder]");
            System.exit(0);
        }
        return baseDir;
    }

    private static void generateDocumentation(Table table, File file, String description) throws Exception {
        System.out.printf("Saving %s docs in '%s'.%n", description, file.getAbsolutePath());
        file.getParentFile().mkdirs();
        try (PrintStream out = new PrintStream(file, StandardCharsets.UTF_8.name());){
            table.print(out);
        }
    }

    public Table generateClassificationDocs() {
        Table table = new Table();
        table.setCols("<1m,<3,<1");
        table.setHeader("Classification", "Description", "Effect on transaction");
        for (Status.Classification classification : (Status.Classification[])Status.Classification.class.getEnumConstants()) {
            table.addRow(this.classificationAsRow(classification));
        }
        return table;
    }

    private Object[] classificationAsRow(Status.Classification classification) {
        String description = classification.description().length() > 0 ? classification.description() : "No description available.";
        String txEffect = classification.rollbackTransaction() ? "Rollback" : "None";
        return new Object[]{classification.name(), description, txEffect};
    }

    public Table generateStatusCodeDocs() {
        Table table = new Table();
        table.setCols("<1m,<1");
        table.setHeader("Status Code", "Description");
        TreeMap<String, Status.Code> sortedStatuses = this.sortedStatusCodes();
        for (String code : sortedStatuses.keySet()) {
            Status.Code statusCode = sortedStatuses.get(code);
            table.addRow(this.codeAsTableRow(statusCode));
        }
        return table;
    }

    private Object[] codeAsTableRow(Status.Code code) {
        String description = code.description().length() > 0 ? code.description() : "No description available.";
        return new Object[]{code.serialize(), description};
    }

    private TreeMap<String, Status.Code> sortedStatusCodes() {
        TreeMap<String, Status.Code> sortedStatuses = new TreeMap<String, Status.Code>();
        for (Status status : Status.Code.all()) {
            sortedStatuses.put(status.code().serialize(), status.code());
        }
        return sortedStatuses;
    }

    public static class Table {
        private String cols;
        private String[] header;
        private List<Object[]> rows = new ArrayList<Object[]>();

        public void setCols(String cols) {
            this.cols = cols;
        }

        public void setHeader(String ... header) {
            this.header = header;
        }

        public void addRow(Object ... xs) {
            this.rows.add(xs);
        }

        public void print(PrintStream out) {
            out.printf("[options=\"header\", cols=\"%s\"]%n", this.cols);
            out.printf("|===%n", new Object[0]);
            for (String columnHeader : this.header) {
                out.printf("|%s ", columnHeader);
            }
            out.printf("%n", new Object[0]);
            Iterator<Object[]> iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                Object[] row;
                for (Object cell : row = (Object[])iterator.next()) {
                    out.printf("|%s ", cell);
                }
                out.printf("%n", new Object[0]);
            }
            out.printf("|===%n", new Object[0]);
        }
    }
}

