/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.transactional.TransactionStateChecker;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;

public class Neo4jJsonCodec
extends ObjectMapper {
    private TransitionalPeriodTransactionMessContainer container;

    public Neo4jJsonCodec(TransitionalPeriodTransactionMessContainer container) {
        this();
        this.container = container;
    }

    public Neo4jJsonCodec() {
        this.getSerializationConfig().without(new SerializationConfig.Feature[]{SerializationConfig.Feature.FLUSH_AFTER_WRITE_VALUE});
    }

    public void writeValue(JsonGenerator out, Object value) throws IOException {
        if (value instanceof PropertyContainer) {
            this.writePropertyContainer(out, (PropertyContainer)value, TransactionStateChecker.create(this.container));
        } else if (value instanceof Path) {
            this.writePath(out, ((Path)value).iterator(), TransactionStateChecker.create(this.container));
        } else if (value instanceof Iterable) {
            this.writeIterator(out, ((Iterable)value).iterator());
        } else if (value instanceof byte[]) {
            this.writeByteArray(out, (byte[])value);
        } else if (value instanceof Map) {
            this.writeMap(out, (Map)value);
        } else {
            super.writeValue(out, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMap(JsonGenerator out, Map value) throws IOException {
        out.writeStartObject();
        try {
            Set set = value.entrySet();
            for (Map.Entry e : set) {
                Object key = e.getKey();
                out.writeFieldName(key == null ? "null" : key.toString());
                this.writeValue(out, e.getValue());
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    private void writeIterator(JsonGenerator out, Iterator value) throws IOException {
        out.writeStartArray();
        try {
            while (value.hasNext()) {
                this.writeValue(out, value.next());
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePath(JsonGenerator out, Iterator<PropertyContainer> value, TransactionStateChecker txStateChecker) throws IOException {
        out.writeStartArray();
        try {
            while (value.hasNext()) {
                this.writePropertyContainer(out, value.next(), txStateChecker);
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    private void writePropertyContainer(JsonGenerator out, PropertyContainer value, TransactionStateChecker txStateChecker) throws IOException {
        if (value instanceof Node) {
            this.writeNodeOrRelationship(out, value, txStateChecker.isNodeDeletedInCurrentTx(((Node)value).getId()));
        } else if (value instanceof Relationship) {
            this.writeNodeOrRelationship(out, value, txStateChecker.isRelationshipDeletedInCurrentTx(((Relationship)value).getId()));
        } else {
            throw new IllegalArgumentException("Expected a Node or Relationship, but got a " + value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeOrRelationship(JsonGenerator out, PropertyContainer entity, boolean isDeleted) throws IOException {
        out.writeStartObject();
        try {
            if (!isDeleted) {
                for (Map.Entry property : entity.getAllProperties().entrySet()) {
                    out.writeObjectField((String)property.getKey(), property.getValue());
                }
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteArray(JsonGenerator out, byte[] bytes) throws IOException {
        out.writeStartArray();
        try {
            for (byte b : bytes) {
                out.writeNumber((int)b);
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    void writeMeta(JsonGenerator out, Object value) throws IOException {
        if (value instanceof Node) {
            Node node = (Node)value;
            this.writeNodeOrRelationshipMeta(out, node.getId(), "node", TransactionStateChecker.create(this.container).isNodeDeletedInCurrentTx(node.getId()));
        } else if (value instanceof Relationship) {
            Relationship relationship = (Relationship)value;
            this.writeNodeOrRelationshipMeta(out, relationship.getId(), "relationship", TransactionStateChecker.create(this.container).isRelationshipDeletedInCurrentTx(relationship.getId()));
        } else if (value instanceof Path) {
            this.writeMetaPath(out, (Path)value);
        } else if (value instanceof Iterable) {
            for (Object v : (Iterable)value) {
                this.writeMeta(out, v);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                this.writeMeta(out, map.get(key));
            }
        } else {
            out.writeNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetaPath(JsonGenerator out, Path value) throws IOException {
        out.writeStartArray();
        try {
            for (PropertyContainer element : value) {
                this.writeMeta(out, element);
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeOrRelationshipMeta(JsonGenerator out, long id, String type, boolean isDeleted) throws IOException {
        out.writeStartObject();
        try {
            out.writeNumberField("id", id);
            out.writeStringField("type", type);
            out.writeBooleanField("deleted", isDeleted);
        }
        finally {
            out.writeEndObject();
        }
    }
}

