/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.AccessMode;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.rest.transactional.TransactionTerminator;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;

public class TransitionalPeriodTransactionMessContainer {
    private final GraphDatabaseFacade db;
    private final ThreadToStatementContextBridge txBridge;

    public TransitionalPeriodTransactionMessContainer(GraphDatabaseFacade db) {
        this.db = db;
        this.txBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    public TransitionalTxManagementKernelTransaction newTransaction(boolean implicitTransaction, AccessMode mode) {
        KernelTransaction.Type type = implicitTransaction ? KernelTransaction.Type.implicit : KernelTransaction.Type.explicit;
        InternalTransaction tx = this.db.beginTransaction(type, mode);
        return new TransitionalTxManagementKernelTransaction(new TransactionTerminator((Transaction)tx), this.txBridge);
    }

    public ThreadToStatementContextBridge getBridge() {
        return this.txBridge;
    }
}

