/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.web.XForwardUtil;

public class AuthorizationFilter
implements Filter {
    private static final Pattern PASSWORD_CHANGE_WHITELIST = Pattern.compile("/user/.*");
    private final Supplier<AuthManager> authManagerSupplier;
    private final Log log;
    private final Pattern[] uriWhitelist;
    private static final ThrowingConsumer<HttpServletResponse, IOException> noHeader = AuthorizationFilter.error(401, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthorizationFailed.code().serialize(), "message", "No authorization header supplied."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> badHeader = AuthorizationFilter.error(400, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Request.InvalidFormat.code().serialize(), "message", "Invalid Authorization header."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> invalidCredential = AuthorizationFilter.error(401, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthorizationFailed.code().serialize(), "message", "Invalid username or password."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> tooManyAttempts = AuthorizationFilter.error(429, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthenticationRateLimit.code().serialize(), "message", "Too many failed authentication requests. Please wait 5 seconds and try again."}))}));

    public AuthorizationFilter(Supplier<AuthManager> authManager, LogProvider logProvider, Pattern ... uriWhitelist) {
        this.authManagerSupplier = authManager;
        this.log = logProvider.getLog(this.getClass());
        this.uriWhitelist = uriWhitelist;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.validateRequestType(servletRequest);
        this.validateResponseType(servletResponse);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String path = request.getContextPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        if (request.getMethod().equals("OPTIONS") || this.whitelisted(path)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header == null) {
            AuthorizationFilter.requestAuthentication(request, noHeader).accept((Object)response);
            return;
        }
        String[] usernameAndPassword = this.extractCredential(header);
        if (usernameAndPassword == null) {
            badHeader.accept((Object)response);
            return;
        }
        String username = usernameAndPassword[0];
        String password = usernameAndPassword[1];
        AuthManager authManager = this.authManagerSupplier.get();
        switch (authManager.authenticate(username, password)) {
            case PASSWORD_CHANGE_REQUIRED: {
                if (!PASSWORD_CHANGE_WHITELIST.matcher(path).matches()) {
                    AuthorizationFilter.passwordChangeRequired(username, this.baseURL(request)).accept((Object)response);
                    return;
                }
            }
            case SUCCESS: {
                try {
                    filterChain.doFilter((ServletRequest)new AuthorizedRequestWrapper("BASIC", username, request), servletResponse);
                }
                catch (AuthorizationViolationException e) {
                    AuthorizationFilter.unauthorizedAccess(e.getMessage()).accept((Object)response);
                }
                return;
            }
            case TOO_MANY_ATTEMPTS: {
                tooManyAttempts.accept((Object)response);
                return;
            }
        }
        this.log.warn("Failed authentication attempt for '%s' from %s", new Object[]{username, request.getRemoteAddr()});
        AuthorizationFilter.requestAuthentication(request, invalidCredential).accept((Object)response);
    }

    private static ThrowingConsumer<HttpServletResponse, IOException> error(int code, Object body) {
        return response -> {
            response.setStatus(code);
            response.addHeader("Content-Type", "application/json; charset=UTF-8");
            response.getOutputStream().write(JsonHelper.createJsonFrom(body).getBytes(StandardCharsets.UTF_8));
        };
    }

    private static ThrowingConsumer<HttpServletResponse, IOException> unauthorizedAccess(String message) {
        return AuthorizationFilter.error(403, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthorizationFailed.code().serialize(), "message", String.format("Unauthorized access violation: %s.", message)}))}));
    }

    private static ThrowingConsumer<HttpServletResponse, IOException> passwordChangeRequired(String username, String baseURL) {
        URI path = UriBuilder.fromUri((String)baseURL).path(String.format("/user/%s/password", username)).build(new Object[0]);
        return AuthorizationFilter.error(403, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthorizationFailed.code().serialize(), "message", "User is required to change their password."})), "password_change", path.toString()}));
    }

    private static ThrowingConsumer<HttpServletResponse, IOException> requestAuthentication(HttpServletRequest req, ThrowingConsumer<HttpServletResponse, IOException> responseGen) {
        if ("true".equals(req.getHeader("X-Ajax-Browser-Auth"))) {
            return res -> {
                responseGen.accept(res);
                res.addHeader("WWW-Authenticate", "None");
            };
        }
        return res -> {
            responseGen.accept(res);
            res.addHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"");
        };
    }

    private String baseURL(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String baseURL = url.substring(0, url.length() - request.getRequestURI().length()) + "/";
        return XForwardUtil.externalUri(baseURL, request.getHeader("X-Forwarded-Host"), request.getHeader("X-Forwarded-Proto"));
    }

    public void destroy() {
    }

    private boolean whitelisted(String path) {
        for (Pattern pattern : this.uriWhitelist) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    private String[] extractCredential(String header) {
        if (header == null) {
            return null;
        }
        return AuthorizationHeaders.decode(header);
    }

    private void validateRequestType(ServletRequest request) throws ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException(String.format("Expected HttpServletRequest, received [%s]", request.getClass().getCanonicalName()));
        }
    }

    private void validateResponseType(ServletResponse response) throws ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException(String.format("Expected HttpServletResponse, received [%s]", response.getClass().getCanonicalName()));
        }
    }
}

