/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.management.console;

import java.rmi.RemoteException;
import java.util.HashMap;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractClient;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.impl.ShellServerKernelExtension;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

public class ShellSession
implements ScriptSession {
    private static volatile ShellServer fallbackServer = null;
    private final ShellClient client;
    private final CollectingOutput output;
    private final Log log;

    public ShellSession(GraphDatabaseAPI graph) {
        try {
            this.log = ((LogService)graph.getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass());
            ShellServerKernelExtension extension = (ShellServerKernelExtension)((KernelExtensions)graph.getDependencyResolver().resolveDependency(KernelExtensions.class)).resolveDependency(ShellServerKernelExtension.class);
            GraphDatabaseShellServer server = extension.getServer();
            if (server == null) {
                server = this.getFallbackServer(graph);
            }
            this.output = new CollectingOutput();
            this.client = new SameJvmClient(new HashMap(), (ShellServer)server, (Output)this.output);
            this.output.asString();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Unable to start shell client", e);
        }
        catch (ShellException e) {
            throw new RuntimeException("Unable to start shell client", e);
        }
    }

    private ShellServer getFallbackServer(GraphDatabaseAPI graph) {
        if (fallbackServer == null) {
            try {
                fallbackServer = new GraphDatabaseShellServer(graph, false);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Unable to start the fallback shellserver", e);
            }
        }
        return fallbackServer;
    }

    @Override
    public Pair<String, String> evaluate(String script) {
        if (script.equals("init()")) {
            return Pair.of((Object)"", (Object)this.client.getPrompt());
        }
        if (script.equals("exit") || script.equals("quit")) {
            return Pair.of((Object)"Sorry, can't do that.", (Object)this.client.getPrompt());
        }
        try {
            this.log.debug(script);
            this.client.evaluate(this.removeInitialNewline(script));
            return Pair.of((Object)this.output.asString(), (Object)this.client.getPrompt());
        }
        catch (ShellException e) {
            String message = ((AbstractClient)this.client).shouldPrintStackTraces() ? ShellException.stackTraceAsString((Throwable)e) : ShellException.getFirstMessage((Throwable)e);
            return Pair.of((Object)message, (Object)this.client.getPrompt());
        }
    }

    private String removeInitialNewline(String script) {
        return script != null && script.startsWith("\n") ? script.substring(1) : script;
    }
}

