/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.management.console.ConsoleService;
import org.neo4j.server.web.WebServer;

public class WebAdminModule
implements ServerModule {
    private static final String DEFAULT_WEB_ADMIN_PATH = "/webadmin";
    private static final String DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION = "webadmin-html";
    private final WebServer webServer;
    private Config config;

    public WebAdminModule(WebServer webServer, Config config) {
        this.webServer = webServer;
        this.config = config;
    }

    @Override
    public void start() {
        if (((Boolean)this.config.get(ServerSettings.webadmin_enabled)).booleanValue()) {
            String serverMountPoint = this.managementApiUri().toString();
            this.webServer.addStaticContent(DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION, DEFAULT_WEB_ADMIN_PATH);
            this.webServer.addJAXRSClasses(this.getClassNames(), serverMountPoint, null);
        }
    }

    private List<String> getClassNames() {
        return Collections.singletonList(ConsoleService.class.getName());
    }

    private URI managementApiUri() {
        return (URI)this.config.get(ServerSettings.management_api_path);
    }

    @Override
    public void stop() {
        if (((Boolean)this.config.get(ServerSettings.webadmin_enabled)).booleanValue()) {
            this.webServer.removeStaticContent(DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION, DEFAULT_WEB_ADMIN_PATH);
        }
    }
}

