/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.neo4j.io.fs.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HttpLogSetting
implements Function<String, File> {
    @Override
    public File apply(String setting) {
        File file = new File(FileUtils.fixSeparatorsInPath((String)setting));
        File logTarget = this.extractLogLocationFromConfig(file);
        if (logTarget != null) {
            this.validateFileBasedLoggingConfig(logTarget);
        }
        return file;
    }

    private void validateFileBasedLoggingConfig(File logLocation) {
        try {
            org.apache.commons.io.FileUtils.forceMkdir((File)logLocation);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("HTTP log directory [%s] does not exist or is not a directory.", logLocation.getAbsolutePath()));
        }
        if (!logLocation.exists()) {
            throw new IllegalArgumentException(String.format("HTTP log directory [%s] could not be created.", logLocation.getAbsolutePath()));
        }
        if (!logLocation.canWrite()) {
            throw new IllegalArgumentException(String.format("HTTP log directory [%s] is not writeable.", logLocation.getAbsolutePath()));
        }
    }

    private File extractLogLocationFromConfig(File configLocation) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(configLocation);
            Node node = doc.getElementsByTagName("file").item(0);
            return new File(node.getTextContent()).getParentFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "a logback config file";
    }
}

