/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.shell.ShellSettings;

public class BaseServerConfigLoader {
    public Config loadConfig(File configFile, File legacyConfigFile, Log log, Pair<String, String> ... configOverrides) {
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null ");
        }
        Config config = new Config();
        config.setLogger(log);
        if (configFile != null && configFile.exists()) {
            config.augment(BaseServerConfigLoader.loadFromFile(log, configFile));
        }
        config.augment(BaseServerConfigLoader.loadFromFile(log, legacyConfigFile));
        BaseServerConfigLoader.overrideEmbeddedDefaults(config);
        this.applyUserOverrides(config, configOverrides);
        config.registerSettingsClasses(BaseServerConfigLoader.getDefaultSettingsClasses());
        return config;
    }

    private void applyUserOverrides(Config config, Pair<String, String>[] configOverrides) {
        Map params = config.getParams();
        for (Pair<String, String> configOverride : configOverrides) {
            params.put(configOverride.first(), configOverride.other());
        }
        config.applyChanges(params);
    }

    private static void overrideEmbeddedDefaults(Config config) {
        Map params = config.getParams();
        if (!params.containsKey(ShellSettings.remote_shell_enabled.name())) {
            params.put(ShellSettings.remote_shell_enabled.name(), "true");
        }
        if (!params.containsKey(GraphDatabaseSettings.log_queries_filename.name())) {
            params.put(GraphDatabaseSettings.log_queries_filename.name(), "data/log/queries.log");
        }
        if (!params.containsKey(BoltKernelExtension.Settings.enabled.name())) {
            params.put(BoltKernelExtension.Settings.enabled.name(), "true");
        }
        config.applyChanges(params);
    }

    protected static Iterable<Class<?>> getDefaultSettingsClasses() {
        return Arrays.asList(ServerSettings.class, GraphDatabaseSettings.class);
    }

    private static Map<String, String> loadFromFile(Log log, File file) {
        if (file == null) {
            return new HashMap<String, String>();
        }
        if (file.exists()) {
            try {
                return MapUtil.load((File)file);
            }
            catch (IOException e) {
                log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
            }
        } else {
            log.warn("Config file [%s] does not exist.", new Object[]{file});
        }
        return new HashMap<String, String>();
    }
}

