/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.management.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.management.console.SessionFactoryImpl;
import org.neo4j.server.rest.management.repr.ConsoleServiceRepresentation;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;

@Path(value="server/console")
public class ConsoleService
implements AdvertisableService {
    public static final String SERVICE_PATH = "server/console";
    private static final String SERVICE_NAME = "console";
    private final ConsoleSessionFactory sessionFactory;
    private final Database database;
    private final LogProvider logProvider;
    private final OutputFormat output;
    private final Log log;

    public ConsoleService(@Context Config config, @Context Database database, @Context LogProvider logProvider, @Context HttpServletRequest req, @Context OutputFormat output, @Context CypherExecutor cypherExecutor) {
        this(new SessionFactoryImpl(req, (List)config.get(ServerSettings.management_console_engines), cypherExecutor), database, logProvider, output);
    }

    public ConsoleService(ConsoleSessionFactory sessionFactory, Database database, LogProvider logProvider, OutputFormat output) {
        this.sessionFactory = sessionFactory;
        this.database = database;
        this.logProvider = logProvider;
        this.output = output;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public String getServerPath() {
        return SERVICE_PATH;
    }

    @GET
    public Response getServiceDefinition() {
        ConsoleServiceRepresentation result = new ConsoleServiceRepresentation(SERVICE_PATH, this.sessionFactory.supportedEngines());
        return this.output.ok((Representation)result);
    }

    @POST
    public Response exec(@Context InputFormat input, String data) {
        ScriptSession scriptSession;
        Map args;
        try {
            args = input.readMap(data, new String[0]);
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        if (!args.containsKey("command")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Expected command argument not present.").build();
        }
        try {
            scriptSession = this.getSession(args);
        }
        catch (IllegalArgumentException e) {
            return this.output.badRequest(e);
        }
        this.log.debug(scriptSession.toString());
        try {
            Pair<String, String> result = scriptSession.evaluate((String)args.get("command"));
            ArrayList<ValueRepresentation> list = new ArrayList<ValueRepresentation>(Arrays.asList(ValueRepresentation.string((String)((String)result.first())), ValueRepresentation.string((String)((String)result.other()))));
            return this.output.ok((Representation)new ListRepresentation(RepresentationType.STRING, list));
        }
        catch (Exception e) {
            ArrayList<ValueRepresentation> list = new ArrayList<ValueRepresentation>(Arrays.asList(ValueRepresentation.string((String)(e.getClass() + " : " + e.getMessage() + "\n")), ValueRepresentation.string(null)));
            return this.output.ok((Representation)new ListRepresentation(RepresentationType.STRING, list));
        }
    }

    private ScriptSession getSession(Map<String, Object> args) {
        return this.sessionFactory.createSession((String)args.get("engine"), this.database, this.logProvider);
    }
}

