/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.tx;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.server.queryapi.tx.Transaction;

public class QueryAPITransaction
implements Transaction {
    private final String transactionId;
    private final org.neo4j.driver.Transaction delegateTransaction;
    private final Session session;
    private final AuthToken authToken;
    private final String databaseName;
    private final ReentrantLock lock = new ReentrantLock();
    private Result currentResult;
    private Instant transactionExpiry;
    private final Duration timeoutExtensionDuration;

    public QueryAPITransaction(String transactionId, org.neo4j.driver.Transaction delegateTransaction, Session session, AuthToken authToken, String databaseName, Instant transactionExpiry, Duration timeoutExtensionDuration) {
        this.transactionId = transactionId;
        this.delegateTransaction = delegateTransaction;
        this.session = session;
        this.authToken = authToken;
        this.databaseName = databaseName;
        this.transactionExpiry = transactionExpiry;
        this.timeoutExtensionDuration = timeoutExtensionDuration;
    }

    @Override
    public void runQuery(String statement, Map<String, Object> parameters) {
        this.currentResult = this.delegateTransaction.run(statement, parameters);
    }

    @Override
    public Result retrieveResults() {
        return this.currentResult;
    }

    @Override
    public Set<Bookmark> commit() {
        this.delegateTransaction.commit();
        return this.session.lastBookmarks();
    }

    @Override
    public void rollback() {
        this.delegateTransaction.rollback();
    }

    @Override
    public ResultSummary resultSummary() {
        return this.currentResult.consume();
    }

    @Override
    public boolean isOpen() {
        return this.delegateTransaction.isOpen();
    }

    @Override
    public void close() {
        this.delegateTransaction.close();
        this.session.close();
    }

    @Override
    public boolean tryAcquire() {
        return this.lock.tryLock();
    }

    @Override
    public void release() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    @Override
    public Instant expiresAt() {
        return this.transactionExpiry;
    }

    @Override
    public String id() {
        return this.transactionId;
    }

    @Override
    public void extendTimeout() {
        this.transactionExpiry = Instant.now().truncatedTo(ChronoUnit.SECONDS).plusSeconds(this.timeoutExtensionDuration.getSeconds());
    }

    @Override
    public String databaseName() {
        return this.databaseName;
    }

    @Override
    public AuthToken authToken() {
        return this.authToken;
    }
}

