/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.api;

import java.util.List;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class InputFormatException
extends RuntimeException
implements ErrorGqlStatusObject {
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    public InputFormatException(String message, Throwable cause) {
        super(message, cause);
        this.gqlStatusObject = null;
        this.oldMessage = message;
    }

    public InputFormatException(ErrorGqlStatusObject errorGqlStatusObject, String message, Throwable cause) {
        super(message, cause);
        this.gqlStatusObject = errorGqlStatusObject;
        this.oldMessage = message;
    }

    public static InputFormatException jsonParingException(String message, Throwable cause) {
        return new InputFormatException(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N11).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N95).build()).build(), message, cause);
    }

    public static InputFormatException jsonMappingException(String message, Throwable cause) {
        return new InputFormatException(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N11).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N96).build()).build(), message, cause);
    }

    @Deprecated
    private InputFormatException(String message) {
        super(message);
        this.gqlStatusObject = null;
        this.oldMessage = message;
    }

    public InputFormatException(ErrorGqlStatusObject errorGqlStatusObject, String message) {
        super(message);
        this.gqlStatusObject = errorGqlStatusObject;
        this.oldMessage = message;
    }

    public static InputFormatException missingRequiredInput(String requiredOption, String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N11).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N06).withParam(GqlParams.ListParam.inputList, List.of(requiredOption)).build()).build();
        throw new InputFormatException(gql, message);
    }

    public static InputFormatException wrongFirstFieldDuringDeserialization(String expectedField, String actualValue) {
        return new InputFormatException(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N11).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N98).withParam(GqlParams.StringParam.field, expectedField).withParam(GqlParams.StringParam.value, actualValue).build()).build(), String.format("Unable to deserialize request. Expected first field to be '%s', but was '%s'.", expectedField, actualValue));
    }

    public static InputFormatException wrongTokenDuringDeserialization(String expectedTokens, String foundTokens) {
        return new InputFormatException(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N11).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N99).withParam(GqlParams.StringParam.token, expectedTokens).withParam(GqlParams.StringParam.value, foundTokens).build()).build(), String.format("Unable to deserialize request. Expected %s, found %s.", expectedTokens, foundTokens));
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

